/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.xbench.project;

import edu.mit.broad.msigdb_browser.genome.JarResources;
import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import org.apache.log4j.Logger;

public class ProjectLoggers {
    private static final Logger klog = Logger.getLogger(ProjectLoggers.class);

    public static class MyLoggerLight {
        private JLabel spinnerImageLabel;

        public void startSpinner(String name, JRootPane rootPane) {
            this.spinnerImageLabel = new JLabel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Rectangle clip = g.getClipBounds();
                    AlphaComposite alphaComposite = AlphaComposite.SrcOver.derive(0.65f);
                    g2d.getComposite();
                    g2d.setComposite(alphaComposite);
                    g2d.setColor(this.getBackground());
                    g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
                }
            };
            Image spinnerImage = JarResources.getImage("wait_spinner.gif").getScaledInstance(128, 128, 1);
            ImageIcon spinnerIcon = new ImageIcon(spinnerImage);
            this.spinnerImageLabel.setIcon(spinnerIcon);
            this.spinnerImageLabel.setHorizontalAlignment(0);
            this.spinnerImageLabel.setVerticalAlignment(0);
            rootPane.setGlassPane(this.spinnerImageLabel);
            rootPane.getGlassPane().setVisible(true);
            rootPane.revalidate();
        }

        public void stopSpinner(JRootPane rootPane) {
            rootPane.getGlassPane().setVisible(false);
            this.spinnerImageLabel = null;
        }

        public void write(String msg) {
            klog.debug((Object)msg);
        }
    }
}

