/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.xbench.core.api;

import edu.mit.broad.msigdb_browser.xbench.core.api.XStore;
import java.io.File;

public class XStores {

    public static class StringStore
    extends XStore {
        StringStore(File file) {
            super.init(file, new XStore.AdditionDecider(){

                @Override
                public String addThis(String str) {
                    if (str == null || str.length() == 0) {
                        return null;
                    }
                    if (!this.contains(str)) {
                        return str;
                    }
                    return null;
                }
            });
        }
    }

    public static class DirPathStore
    extends XStore {
        DirPathStore(File file) {
            super.init(file, new XStore.AdditionDecider(){

                @Override
                public String addThis(String str) {
                    if (str == null || str.length() == 0) {
                        return null;
                    }
                    if (str.endsWith(".rpt")) {
                        return null;
                    }
                    File dir = new File(str);
                    if (!dir.isDirectory()) {
                        dir = dir.getParentFile();
                    }
                    if (dir.exists() && !this.contains(str) && !this.contains(dir.getPath()) && !this.contains(dir.getAbsolutePath())) {
                        return dir.getPath();
                    }
                    return null;
                }
            });
        }
    }

    public static class FilePathStore
    extends XStore {
        FilePathStore(File file) {
            super.init(file, new XStore.AdditionDecider(){

                @Override
                public String addThis(String str) {
                    if (str == null || str.length() == 0) {
                        return null;
                    }
                    if (str.endsWith(".rpt")) {
                        return null;
                    }
                    File file = new File(str);
                    if (file.exists() && !this.contains(str)) {
                        return str;
                    }
                    return null;
                }
            });
        }
    }
}

