/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.xbench.actions.ext;

import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.xbench.actions.ExtAction;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.Icon;

public class BrowserAction
extends ExtAction {
    private static final String NAME = "Web Browser";
    private static final Icon ICON = JarResources.getIcon("Htm.gif");

    public BrowserAction(String path) {
        this(NAME, null, ICON, path);
    }

    public BrowserAction(String name, String desc, Icon icon, String path) {
        super("BrowserAction", name, desc, icon);
        this.setPath(path);
    }

    public BrowserAction(String name, String desc, Icon icon, File file) {
        super("BrowserAction", name, desc, icon);
        this.setPath(file.toString());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            if (this.getPath() == null) {
                throw new NullPointerException("null path associated with BrowserAction");
            }
            Desktop.getDesktop().browse(new URI(this.getPath()));
            Application.getFileManager().registerRecentlyOpenedURL(this.getPath());
        }
        catch (Exception e) {
            Application.getWindowManager().showError("Could not launch browser", e);
        }
    }
}

