/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.meg;

import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class DefaultGene
implements Gene {
    private String fSymbol;
    private String fTitle;
    protected String fCyto_opt = null;
    private Set fAliases = null;
    protected Set fSeqAccessions = null;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public DefaultGene() {
    }

    public Gene cloneDeep() {
        DefaultGene gene = new DefaultGene();
        gene.fSymbol = this.fSymbol;
        gene.fTitle = this.fTitle;
        gene.fAliases = new HashSet(this.fAliases);
        gene.fSeqAccessions = new HashSet(this.fSeqAccessions);
        return gene;
    }

    public DefaultGene(String symbol, String title) {
        if (symbol == null) {
            throw new IllegalArgumentException("Parameter symbol cannot be null");
        }
        this.fTitle = NamingConventions.titleize(title);
        this.fSymbol = symbol.toUpperCase();
    }

    @Override
    public String getSymbol() {
        return this.fSymbol;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public String getTitle_truncated() {
        return Gene.Helper.getTitle_truncated(this.fTitle);
    }

    @Override
    public Set getAliases() {
        if (this.fAliases == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.fAliases);
    }

    @Override
    public String[] getAliasesArray() {
        Set set = this.getAliases();
        return set.toArray(new String[set.size()]);
    }

    public boolean equals(Object obj) {
        return obj instanceof Gene && ((Gene)obj).getSymbol().equalsIgnoreCase(this.getSymbol());
    }

    public String toString() {
        return this.getSymbol();
    }

    public int hashCode() {
        return this.getSymbol().hashCode();
    }
}

