/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.meg;

import edu.mit.broad.msigdb_browser.genome.NotImplementedException;
import edu.mit.broad.msigdb_browser.genome.objects.AbstractObject;
import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.chip.Probe;
import edu.mit.broad.msigdb_browser.vdb.chip.SimpleProbe2;
import edu.mit.broad.msigdb_browser.vdb.meg.AliasDb;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class AliasDbImpl
extends AbstractObject
implements AliasDb {
    private Chip fChip_opt;
    private Map fAliasSymbolMap;

    public AliasDbImpl(Chip chip_opt) {
        super.initialize(AliasDbImpl._name(chip_opt));
        this.fChip_opt = chip_opt;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public boolean isAlias(String alias) throws Exception {
        String symbol = this.getSymbol(alias);
        return symbol != null;
    }

    public String getSymbol(String alias) throws Exception {
        if (alias == null) {
            throw new IllegalArgumentException("Param alias cannot be null");
        }
        this._initAliasSymbolMap();
        Object obj = this.fAliasSymbolMap.get(alias);
        if (obj != null) {
            return obj.toString();
        }
        obj = this.fAliasSymbolMap.get(alias.toUpperCase());
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    @Override
    public Gene getHugo(String alias) throws Exception {
        if (this.fChip_opt == null) {
            throw new NotImplementedException("Only works for in mem gene symbol chip");
        }
        String symbol = this.getSymbol(alias);
        return this.fChip_opt.getHugo(symbol);
    }

    @Override
    public Probe[] getAliasesAsProbes() throws Exception {
        this._initAliasSymbolMap();
        Probe[] probes = new Probe[this.fAliasSymbolMap.size()];
        int cnt = 0;
        Iterator iterator = this.fAliasSymbolMap.keySet().iterator();
        while (iterator.hasNext()) {
            String alias = iterator.next().toString();
            String symbol = this.fAliasSymbolMap.get(alias).toString();
            probes[cnt++] = new SimpleProbe2(alias, symbol, VdbRuntimeResources.getChip_Gene_Symbol());
        }
        return probes;
    }

    private static String _name(Chip chip_opt) {
        if (chip_opt != null) {
            return chip_opt.getName();
        }
        throw new IllegalArgumentException("Both file and chip cannot be null");
    }

    private void _initAliasSymbolMap() throws Exception {
        if (this.fAliasSymbolMap != null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashSet<String> duplicates = new HashSet<String>();
        Probe[] probes = this.fChip_opt.getProbes();
        for (int i = 0; i < probes.length; ++i) {
            Gene gene = probes[i].getGene();
            if (gene == null || gene == Gene.NULL_GENE || gene.getAliases() == null || gene.getAliases().isEmpty()) continue;
            String symbol = gene.getSymbol();
            String[] aliases = gene.getAliasesArray();
            for (int s = 0; s < aliases.length; ++s) {
                String alias = aliases[s].toUpperCase();
                if (map.containsKey(alias)) {
                    duplicates.add(alias);
                    continue;
                }
                map.put(alias, symbol);
            }
        }
        if (!duplicates.isEmpty()) {
            this.log.warn((Object)("There are duplicate entry for accessions: " + duplicates.size() + " ignoring them ... total #: " + map.size()));
        }
        this.log.info((Object)("# of aliases: " + map.size()));
        this.fAliasSymbolMap = map;
    }
}

