/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.map;

import edu.mit.broad.msigdb_browser.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.vdb.map.MGeneSet;
import edu.mit.broad.msigdb_browser.vdb.map.MGeneSetImpl;
import edu.mit.broad.msigdb_browser.vdb.map.MGeneSetMatrix;
import edu.mit.broad.msigdb_browser.vdb.map.Mapper;
import edu.mit.broad.msigdb_browser.vdb.map.MappingDbType;

class MGeneSetMatrixImpl
implements MGeneSetMatrix {
    private MGeneSet[] mappedGeneSets;
    private String fOrigGmName;

    MGeneSetMatrixImpl(GeneSetMatrix sourceGeneSetMatrix, String sourceChipName, String targetChipName, MappingDbType dbType, Mapper mapper) throws Exception {
        if (sourceGeneSetMatrix == null) {
            throw new IllegalArgumentException("Param sourceGeneSetMatrix cannot be null");
        }
        if (sourceChipName == null) {
            throw new IllegalArgumentException("Param sourceChipName cannot be null");
        }
        if (targetChipName == null) {
            throw new IllegalArgumentException("Param targetChipName cannot be null");
        }
        this.mappedGeneSets = new MGeneSet[sourceGeneSetMatrix.getNumGeneSets()];
        for (int i = 0; i < sourceGeneSetMatrix.getNumGeneSets(); ++i) {
            this.mappedGeneSets[i] = new MGeneSetImpl(sourceGeneSetMatrix.getGeneSet(i), sourceChipName, targetChipName, dbType, mapper);
        }
        this.fOrigGmName = sourceGeneSetMatrix.getName();
    }

    @Override
    public GeneSetMatrix getMappedGeneSetMatrix(String prefix) {
        GeneSet[] gsets = new GeneSet[this.mappedGeneSets.length];
        for (int i = 0; i < gsets.length; ++i) {
            gsets[i] = this.mappedGeneSets[i].getMappedGeneSet();
        }
        Object name = prefix == null || prefix.length() == 0 ? this.fOrigGmName : prefix + "_" + this.fOrigGmName;
        return new DefaultGeneSetMatrix((String)name, gsets);
    }
}

