/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.chip;

import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.vdb.chip.Probe;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SimpleProbe3
implements Probe,
Gene {
    private String fSymbol;
    private String fTitle;
    private Set fAliases;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public SimpleProbe3(String symbol, String title, Set aliases) {
        if (symbol == null) {
            throw new IllegalArgumentException("Parameter symbol cannot be null");
        }
        this.fTitle = NamingConventions.titleize(title);
        this.fSymbol = symbol.toUpperCase();
        this.fAliases = aliases;
    }

    @Override
    public String getSymbol() {
        return this.fSymbol;
    }

    @Override
    public String getTitle() {
        return this.fTitle;
    }

    @Override
    public String getTitle_truncated() {
        return Gene.Helper.getTitle_truncated(this.fTitle);
    }

    @Override
    public Set getAliases() {
        if (this.fAliases == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.fAliases);
    }

    public void removeAnyAliasesThatMatch(Set these) {
        if (this.fAliases != null && !this.fAliases.isEmpty()) {
            this.fAliases.removeAll(these);
            this.fAliases = Collections.unmodifiableSet(this.fAliases);
        }
    }

    @Override
    public String[] getAliasesArray() {
        Set set = this.getAliases();
        return set.toArray(new String[set.size()]);
    }

    public String toString() {
        return this.getSymbol();
    }

    public int hashCode() {
        return this.getSymbol().hashCode();
    }

    @Override
    public String getName() {
        return this.getSymbol();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Probe) {
            String id = ((Probe)obj).getName();
            return id.equals(this.getName());
        }
        if (obj instanceof Gene) {
            String id = ((Gene)obj).getSymbol();
            return id.equals(this.getSymbol());
        }
        return false;
    }

    @Override
    public Gene getGene() {
        return this;
    }
}

