/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.vdb.chip;

import edu.mit.broad.msigdb_browser.genome.objects.AbstractObject;
import edu.mit.broad.msigdb_browser.genome.objects.FSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.chip.NullSymbolMode;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;
import java.util.ArrayList;

public abstract class AbstractChip
extends AbstractObject
implements Chip {
    protected String fSourcePath;

    @Override
    public Chip cloneShallow(String newName) {
        super.setName(newName);
        return this;
    }

    protected AbstractChip() {
    }

    public AbstractChip(String chipName, String sourcePath) {
        super.initialize(chipName);
        if (sourcePath == null) {
            throw new IllegalArgumentException("Parameter sourcePath cannot be null");
        }
        this.fSourcePath = sourcePath;
    }

    public boolean equals(Object obj) {
        return obj instanceof Chip && ((Chip)obj).getName().equalsIgnoreCase(this.getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public GeneSet getProbeNamesAsGeneSet() throws Exception {
        return new FSet(this.getName(), this.getProbeNames());
    }

    @Override
    public Gene getHugo(String probeName) throws Exception {
        return this.getProbe(probeName).getGene();
    }

    @Override
    public String getSymbol(String probeName, NullSymbolMode nmode) {
        try {
            if (this.isProbe(probeName)) {
                return nmode.getSymbol(probeName, this.getHugo(probeName));
            }
            return nmode.getSymbol(probeName, null);
        }
        catch (Throwable t) {
            this.log.error((Object)t);
            return "";
        }
    }

    @Override
    public GeneSet symbolize(GeneSet gset) {
        ArrayList<String> names = new ArrayList<String>();
        for (int r = 0; r < gset.getNumMembers(); ++r) {
            String n = this.getSymbol(gset.getMember(r), OMIT_NULLS);
            if (n == null || names.contains(n)) continue;
            names.add(n);
        }
        return new FSet(gset.getName(), names, false);
    }
}

