/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.utils;

import edu.mit.broad.msigdb_browser.genome.utils.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class FileUtils {
    public static void write(List<?> list, File file) throws IOException {
        try (PrintWriter out = new PrintWriter(new FileOutputStream(file));){
            IOUtils.writeLines(list, (String)IOUtils.LINE_SEPARATOR, (Writer)out);
        }
    }

    public static boolean isLocked(File file) {
        if (!file.exists()) {
            return false;
        }
        File origFile = new File(file.getAbsolutePath());
        StringBuffer btmp = new StringBuffer(file.getName()).append(System.currentTimeMillis()).append(".lock_check");
        File newFile = new File(SystemUtils.getTmpDir(), btmp.toString());
        boolean able2rename = file.renameTo(newFile);
        if (!able2rename) {
            return true;
        }
        boolean movedback = newFile.renameTo(origFile);
        if (!movedback) {
            throw new IllegalStateException("Bad error - couldnt move file back after lock check");
        }
        return false;
    }
}

