/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.Constants;
import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.io.FtpResultInputStream;
import edu.mit.broad.msigdb_browser.genome.io.FtpSingleUrlTransferCommand;
import edu.mit.broad.msigdb_browser.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.AuxUtils;
import edu.mit.broad.msigdb_browser.genome.parsers.ChipParser;
import edu.mit.broad.msigdb_browser.genome.parsers.FSetParser;
import edu.mit.broad.msigdb_browser.genome.parsers.GmtParser;
import edu.mit.broad.msigdb_browser.genome.parsers.GmxParser;
import edu.mit.broad.msigdb_browser.genome.parsers.MSigDBParser;
import edu.mit.broad.msigdb_browser.genome.parsers.ObjectCache;
import edu.mit.broad.msigdb_browser.genome.parsers.ReportParser;
import edu.mit.broad.msigdb_browser.genome.reports.api.Report;
import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import edu.mit.broad.msigdb_browser.xbench.core.api.Application;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import xapps.browser.gsea.GseaWebResources;

public class ParserFactory
implements Constants {
    private static final File fileCacheDir = new File(Application.getVdbManager().getRuntimeHomeDir(), "file_cache");
    private static final File chipCacheDir = new File(fileCacheDir, "chip");
    private static final Logger klog;
    private static final ObjectCache kDefaultObjectCache;

    private ParserFactory() {
    }

    static ObjectCache _getCache() {
        return kDefaultObjectCache;
    }

    public static ObjectCache getCache() {
        return ParserFactory._getCache();
    }

    public static GeneSet readGeneSet(File file) throws Exception {
        InputStream is = ParserFactory.createInputStream(file);
        return ParserFactory.readGeneSet(file.getPath(), is, true, true);
    }

    private static GeneSet readGeneSet(String path, InputStream is, boolean useCache, boolean add2Cache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(path, GeneSet.class) && useCache) {
            is.close();
            return (GeneSet)ParserFactory._getCache().get(path, GeneSet.class);
        }
        if (AuxUtils.isAux(path)) {
            String gsetName = AuxUtils.getAuxNameOnlyNoHash(path);
            File f = AuxUtils.getBaseFileFromAuxFile(new File(path));
            GeneSetMatrix gm = ParserFactory.readGeneSetMatrix(f.getPath(), ParserFactory.createInputStream(f), useCache, true, add2Cache);
            return gm.getGeneSet(gsetName);
        }
        FSetParser parser = new FSetParser();
        GeneSet gset = (GeneSet)parser.parse(ParserFactory.toName(path), is).get(0);
        ParserFactory._getCache().addInvisibly(path, (PersistentObject)new DefaultGeneSetMatrix(gset.getName(), new GeneSet[]{gset}));
        if (add2Cache) {
            ParserFactory._getCache().add(path, (PersistentObject)gset, GeneSet.class);
        }
        is.close();
        return gset;
    }

    private static Report readReport(String path, InputStream is, boolean useCache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(path, Report.class) && useCache) {
            is.close();
            return (Report)ParserFactory._getCache().get(path, Report.class);
        }
        ReportParser parser = new ReportParser();
        Report rpt = (Report)parser.parse(ParserFactory.toName(path), is).get(0);
        if (useCache) {
            ParserFactory._getCache().add(path, (PersistentObject)rpt, Report.class);
        }
        is.close();
        return rpt;
    }

    public static Chip readChip(String sourcePath, boolean useCache) throws Exception {
        return ParserFactory.readChip(sourcePath, ParserFactory.createInputStream(sourcePath), useCache);
    }

    private static Chip readChip(String path, InputStream is, boolean useCache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (ParserFactory._getCache().isCached(path, Chip.class) && useCache) {
            is.close();
            return (Chip)ParserFactory._getCache().get(path, Chip.class);
        }
        ChipParser parser = new ChipParser();
        Chip chip = (Chip)parser.parse(path, is).get(0);
        if (useCache) {
            ParserFactory._getCache().add(path, (PersistentObject)chip, Chip.class);
        }
        is.close();
        return chip;
    }

    private static GeneSetMatrix readGeneSetMatrix(String path, InputStream is, boolean useCache, boolean checkforduplicates, boolean add2Cache) throws Exception {
        String ext;
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (AuxUtils.isAux(path)) {
            path = AuxUtils.getBasePathFromAuxPath(path);
        }
        if ((ext = NamingConventions.getExtension(path)).equals("gmt")) {
            return ParserFactory.readGeneSetMatrixT(path, is, useCache, checkforduplicates, add2Cache);
        }
        if (ext.equals("grp")) {
            GeneSet gset = ParserFactory.readGeneSet(path, is, useCache, add2Cache);
            return new DefaultGeneSetMatrix(ParserFactory.toName(path), new GeneSet[]{gset});
        }
        if (ParserFactory._getCache().isCached(path, GeneSetMatrix.class) && useCache) {
            is.close();
            return (GeneSetMatrix)ParserFactory._getCache().get(path, GeneSetMatrix.class);
        }
        GmxParser parser = new GmxParser();
        parser.setCheckForDuplicates(checkforduplicates);
        GeneSetMatrix gmx = (GeneSetMatrix)parser.parse(ParserFactory.toName(path), is).get(0);
        if (add2Cache) {
            ParserFactory._getCache().add(path, (PersistentObject)gmx, GeneSetMatrix.class);
        }
        File parentFile = new File(path).getParentFile();
        for (int i = 0; i < gmx.getNumGeneSets(); ++i) {
            File pseudo = new File(parentFile, gmx.getGeneSet(i).getName());
            if (!add2Cache) continue;
            ParserFactory._getCache().addInvisibly(pseudo, (PersistentObject)gmx.getGeneSet(i));
        }
        if (add2Cache) {
            ParserFactory._getCache().sortModel(GeneSet.class);
            ParserFactory._getCache().hackAddAuxSets(gmx);
        }
        is.close();
        return gmx;
    }

    private static GeneSetMatrix readGeneSetMatrixT(String path, InputStream is, boolean useCache, boolean checkForDuplicates, boolean add2Cache) throws Exception {
        String ext;
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (AuxUtils.isAux(path)) {
            path = AuxUtils.getBasePathFromAuxPath(path);
        }
        if ((ext = NamingConventions.getExtension(path)).equals("gmx")) {
            return ParserFactory.readGeneSetMatrix(path, is, useCache, checkForDuplicates, add2Cache);
        }
        if (ext.equals("grp")) {
            GeneSet gset = ParserFactory.readGeneSet(path, is, useCache, true);
            return new DefaultGeneSetMatrix(ParserFactory.toName(path), new GeneSet[]{gset});
        }
        if (ParserFactory._getCache().isCached(path, GeneSetMatrix.class) && useCache) {
            is.close();
            return (GeneSetMatrix)ParserFactory._getCache().get(path, GeneSetMatrix.class);
        }
        GmtParser parser = new GmtParser();
        GeneSetMatrix gmx = (GeneSetMatrix)parser.parse(ParserFactory.toName(path), is).get(0);
        ParserFactory._getCache().add(path, (PersistentObject)gmx, GeneSetMatrix.class);
        File parentFile = new File(path).getParentFile();
        for (int i = 0; i < gmx.getNumGeneSets(); ++i) {
            File pseudo = new File(parentFile, gmx.getGeneSet(i).getName());
            ParserFactory._getCache().addInvisibly(pseudo, (PersistentObject)gmx.getGeneSet(i));
        }
        ParserFactory._getCache().hackAddAuxSets(gmx);
        is.close();
        return gmx;
    }

    public static MSigDB readMSigDB(String path, InputStream is, boolean useCache, boolean deepInitAtLoad) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (ParserFactory._getCache().isCached(path, MSigDB.class) && useCache) {
            return (MSigDB)ParserFactory._getCache().get(path, MSigDB.class);
        }
        long startTime = System.currentTimeMillis();
        MSigDBParser parser = new MSigDBParser();
        MSigDB msigdb = (MSigDB)parser.parse(path, is).get(0);
        klog.info((Object)("Done parsing.  Time: " + (System.currentTimeMillis() - startTime)));
        ParserFactory._getCache().add(path, (PersistentObject)msigdb, MSigDB.class);
        return msigdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PersistentObject read(File file, boolean useCache) throws Exception {
        File baseFile = AuxUtils.getBaseFileFromAuxFile(file);
        String path = file.getPath();
        try (InputStream is = ParserFactory.createInputStream(baseFile);){
            if (path == null) {
                throw new IllegalArgumentException("Param file cannot be null");
            }
            if (is == null) {
                throw new IllegalArgumentException("Param is cannot be null");
            }
            String tmp = ParserFactory.stripAt(path);
            String ext = NamingConventions.getExtensionLiberal(tmp).toLowerCase();
            if (ext.equalsIgnoreCase("grp")) {
                GeneSet geneSet = ParserFactory.readGeneSet(path, is, useCache, true);
                return geneSet;
            }
            if (ext.startsWith("gmx")) {
                GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrix(path, is, useCache, true, true);
                return geneSetMatrix;
            }
            if (ext.startsWith("gmt")) {
                GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrixT(path, is, useCache, true, true);
                return geneSetMatrix;
            }
            if (ext.equalsIgnoreCase("rpt")) {
                Report report = ParserFactory.readReport(path, is, useCache);
                return report;
            }
            if (ext.equalsIgnoreCase("chip") || ext.equalsIgnoreCase("csv")) {
                Chip chip = ParserFactory.readChip(path, is, useCache);
                return chip;
            }
            try {
                throw new IllegalArgumentException("Unknown file format: " + path + " no known Parser for ext: " + ext);
            }
            catch (InterruptedIOException e) {
                klog.info((Object)"progress exception - possibly cancelled ... ignoring");
                PersistentObject persistentObject = null;
                return persistentObject;
            }
        }
    }

    private static String stripAt(String path) {
        StringTokenizer tok = new StringTokenizer(path, "@");
        return tok.nextToken();
    }

    public static void save(GeneSet gset, File toFile) throws Exception {
        FSetParser parser = new FSetParser();
        parser.export(gset, toFile);
        ParserFactory._getCache().add(toFile, (PersistentObject)gset, GeneSet.class);
    }

    public static void saveGmt(GeneSetMatrix gmt, File toFile, boolean add2cache) throws Exception {
        GmtParser parser = new GmtParser();
        parser.export(gmt, toFile);
        if (add2cache) {
            ParserFactory._getCache().add(toFile, (PersistentObject)gmt, GeneSetMatrix.class);
        }
    }

    public static void save(GeneSetMatrix gmx, File toFile, boolean add2cache) throws Exception {
        GmxParser parser = new GmxParser();
        parser.export(gmx, toFile);
        if (add2cache) {
            ParserFactory._getCache().add(toFile, (PersistentObject)gmx, GeneSetMatrix.class);
        }
    }

    private static String toName(String path) {
        return new File(path).getName();
    }

    private static InputStream createInputStream(File file) throws IOException {
        if (NamingConventions.isURL(file.getPath())) {
            return ParserFactory.createInputStream(new URL(file.getPath()));
        }
        if (AuxUtils.isAuxFile(file)) {
            file = AuxUtils.getBaseFileFromAuxFile(file);
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IOException("Specified path is a Directory (expecting a File): " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("Check file permissions - cannot read data from file: " + file.getAbsolutePath());
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    private static InputStream createInputStream(URL url) throws IOException {
        String filePath = url.getPath();
        File localFile = null;
        boolean isGeneSymbolChip = VdbRuntimeResources.isPathGeneSymbolChip(filePath);
        boolean isSeqAccessionChip = VdbRuntimeResources.isChipSeqAccession(filePath);
        if (isGeneSymbolChip || isSeqAccessionChip) {
            String localFileName = isGeneSymbolChip ? "GENE_SYMBOL.chip" : "SEQ_ACCESSION.chip";
            url = new URL("ftp://ftp.broadinstitute.org/pub/gsea/annotations/" + localFileName);
            localFile = new File(chipCacheDir, localFileName);
            if (localFile.exists() && localFile.isFile()) {
                klog.info((Object)("File found in local file cache; will process " + localFile.getAbsolutePath() + " in place of " + url.toString() + ".  Ignore any following message(s) about this URL."));
                return new BufferedInputStream(new FileInputStream(localFile));
            }
        }
        klog.debug((Object)("Parsing URL: " + url.getPath() + " >> " + url.toString()));
        if (url.getProtocol().equalsIgnoreCase("ftp") && url.getHost().equalsIgnoreCase(GseaWebResources.getGseaFTPServer())) {
            try {
                FtpSingleUrlTransferCommand ftpCommand = new FtpSingleUrlTransferCommand(url);
                FtpResultInputStream ftpInputStream = ftpCommand.retrieveAsInputStream();
                if (localFile != null && !localFile.exists()) {
                    FileUtils.copyInputStreamToFile((InputStream)ftpInputStream, (File)localFile);
                    return new BufferedInputStream(new FileInputStream(localFile));
                }
                return ftpInputStream;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return new BufferedInputStream(url.openStream());
    }

    public static InputStream createInputStream(Object source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        if (source instanceof File) {
            return ParserFactory.createInputStream((File)source);
        }
        if (source instanceof URL) {
            return ParserFactory.createInputStream((URL)source);
        }
        Object path = source.toString();
        if (NamingConventions.isURL((String)path)) {
            if (((String)path).startsWith("ftp.")) {
                path = "ftp://" + (String)path;
            } else if (((String)path).startsWith("gseaftp.")) {
                path = "ftp://" + (String)path;
            }
            return ParserFactory.createInputStream(new URL((String)path));
        }
        File file = new File((String)path);
        if (file.exists()) {
            return ParserFactory.createInputStream(file);
        }
        throw new IOException("Bad data source -- neither file nor url exists for: " + source);
    }

    static {
        if (!chipCacheDir.exists()) {
            chipCacheDir.mkdirs();
        }
        klog = Logger.getLogger(ParserFactory.class);
        kDefaultObjectCache = new ObjectCache();
    }
}

