/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class ParseUtils {
    private static final char DEFAULT_FIELD_SEP_CSV = ',';
    public static final String DEFAULT_DELIMS = " \t\n,;:";
    private static final String[] MAGIC_NULLS = new String[]{"NULL", "na", "-", "---"};

    public static String[] string2strings(String s, String delim, boolean useNullonMagicNullWord) throws IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot parse on null String");
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        String[] ret = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            ret[i] = ParseUtils._magic(tok.nextToken().trim(), useNullonMagicNullWord);
            ++i;
        }
        return ret;
    }

    public static String[] string2stringsV2(String s) throws IllegalArgumentException {
        List ret = ParseUtils.string2stringsV2_list(s);
        return ret.toArray(new String[ret.size()]);
    }

    public static List string2stringsV2_list(String s) throws IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        s = s.trim();
        StringTokenizer tok = new StringTokenizer(s, "\t", true);
        ArrayList<String> ret = new ArrayList<String>();
        String prev = null;
        while (tok.hasMoreTokens()) {
            String curr = tok.nextToken();
            if (!curr.equals("\t")) {
                ret.add(curr);
            }
            if (curr.equals(prev)) {
                ret.add("");
            }
            prev = curr;
        }
        return ret;
    }

    public static List string2stringsList(String s, String delim) throws IllegalArgumentException {
        if (null == s) {
            throw new NullPointerException("Cannot work on null String");
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        ArrayList<String> ret = new ArrayList<String>(tok.countTokens());
        while (tok.hasMoreTokens()) {
            ret.add(tok.nextToken().trim());
        }
        return ret;
    }

    public static Set string2stringsSet(String s, String delim, boolean respectNullMagicWord) throws IllegalArgumentException {
        if (null == s) {
            return new HashSet();
        }
        StringTokenizer tok = new StringTokenizer(s, delim);
        HashSet<String> ret = new HashSet<String>();
        while (tok.hasMoreTokens()) {
            String elem = tok.nextToken().trim();
            if ((elem = ParseUtils._magic(elem, respectNullMagicWord)) == null) continue;
            ret.add(elem);
        }
        return ret;
    }

    private static String _magic(String s, boolean respectNullMagicWord) {
        return ParseUtils._magic(s, MAGIC_NULLS, respectNullMagicWord);
    }

    private static String _magic(String s, String[] magicNulls, boolean respectNullMagicWord) {
        if (respectNullMagicWord) {
            for (int i = 0; i < magicNulls.length; ++i) {
                if (!s.trim().equalsIgnoreCase(magicNulls[i])) continue;
                return null;
            }
        }
        return s;
    }

    public static List readFfn(File aFile) throws IOException {
        BufferedReader buf = new BufferedReader(new FileReader(aFile));
        ArrayList<String> lines = new ArrayList<String>();
        String line = ParseUtils.nextLine(buf);
        while (line != null) {
            if (!lines.contains(line)) {
                lines.add(line);
            }
            line = ParseUtils.nextLine(buf);
        }
        buf.close();
        return lines;
    }

    public static String[] slurpIntoArray(URL url, boolean ignoreanycomments) throws IOException {
        Set set = ParseUtils.slurpIntoSet(ParseUtils._buf(url), ignoreanycomments);
        return set.toArray(new String[set.size()]);
    }

    public static Set slurpIntoSet(BufferedReader buf, boolean ignoreanycomments) throws IOException {
        String line;
        HashSet<String> set = new HashSet<String>();
        while ((line = buf.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || ignoreanycomments && line.startsWith("#")) continue;
            set.add(line);
        }
        buf.close();
        return set;
    }

    public static String nextLine(BufferedReader buf) throws IOException {
        String currLine = buf.readLine();
        if (currLine == null) {
            return null;
        }
        currLine = currLine.trim();
        while (currLine != null && (currLine.length() == 0 || currLine.startsWith("#"))) {
            currLine = buf.readLine();
            if (currLine == null) continue;
            currLine = currLine.trim();
        }
        return currLine;
    }

    private static BufferedReader _buf(URL url) throws IOException {
        if (url == null) {
            throw new IllegalArgumentException("Parameter url cannot be null");
        }
        InputStreamReader isr = new InputStreamReader(url.openStream());
        return new BufferedReader(isr);
    }

    public static String[] string2strings_csv(String csvLine) {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        do {
            sb.setLength(0);
            if (i < csvLine.length() && csvLine.charAt(i) == '\"') {
                ++i;
                i = ParseUtils.advQuoted_for_csv(csvLine, sb, i);
            } else {
                i = ParseUtils.advPlain_for_csv(csvLine, sb, i);
            }
            list.add(sb.toString());
        } while (++i < csvLine.length());
        return list.toArray(new String[list.size()]);
    }

    public static List string2stringsList_csv(String csvLine) {
        String[] ss = ParseUtils.string2strings_csv(csvLine);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ss.length; ++i) {
            list.add(ss[i]);
        }
        return list;
    }

    private static int advQuoted_for_csv(String s, StringBuffer sb, int i) {
        int j;
        int len = s.length();
        for (j = i; j < len; ++j) {
            if (s.charAt(j) == '\"' && j + 1 < len) {
                if (s.charAt(j + 1) == '\"') {
                    ++j;
                } else if (s.charAt(j + 1) == ',') {
                    ++j;
                    break;
                }
            } else if (s.charAt(j) == '\"' && j + 1 == len) break;
            sb.append(s.charAt(j));
        }
        return j;
    }

    private static int advPlain_for_csv(String s, StringBuffer sb, int i) {
        int j = s.indexOf(44, i);
        if (j == -1) {
            sb.append(s.substring(i));
            return s.length();
        }
        sb.append(s.substring(i, j));
        return j;
    }
}

