/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.PobBoxModel;
import edu.mit.broad.msigdb_browser.genome.reports.api.Report;
import edu.mit.broad.msigdb_browser.genome.swing.ProxyComboBoxModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;

public class ObjectCache {
    private final Logger log = Logger.getLogger(ObjectCache.class);
    private final Map fClassNameNodeMap = new Hashtable();
    private final Map fClassNameBoxModelMap = new Hashtable();
    private final DefaultTreeModel fTreeModel;
    private final DefaultMutableTreeNode fRootNode;
    private final Map fPathClassObjectMap = new HashMap();
    private final Map fObjectPathStringMap = new HashMap();
    private final Map fInvisiblePobFileMap = new HashMap();
    private final PropertyChangeSupport fPathChanges = new PropertyChangeSupport(this);
    private final PropertyChangeSupport fReportChanges = new PropertyChangeSupport(this);
    public static final String PROP_PATH_ADDED = "path_added";
    public static final String PROP_REPORT_ADDED = "pob_added";
    private PobBoxModel auxsetsmodel;

    public ObjectCache() {
        this("<html><body><font type=bold>Objects in memory</font><font color=gray size=-2> [shift-click to expand all]</font></body></html>");
    }

    private ObjectCache(String rootNodeLabel) {
        this.fRootNode = new DefaultMutableTreeNode(rootNodeLabel);
        this.fTreeModel = new DefaultTreeModel(this.fRootNode, true);
    }

    public boolean isCached(String path, Class cl) {
        return this.fPathClassObjectMap.containsKey(new PathClass(path, cl));
    }

    public boolean isCached(PersistentObject pob) {
        if (this.fObjectPathStringMap.containsKey(pob)) {
            return true;
        }
        return this.fInvisiblePobFileMap.containsKey(pob);
    }

    public Object get(String path, Class cl) {
        return this.fPathClassObjectMap.get(new PathClass(path, cl));
    }

    public String getSourcePath(Object pob) {
        if (pob == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        Object fo = this.fObjectPathStringMap.get(pob);
        if (fo == null && this.fInvisiblePobFileMap.containsKey(pob)) {
            fo = ((File)this.fInvisiblePobFileMap.get(pob)).getPath();
        }
        if (fo != null) {
            return fo.toString();
        }
        throw new IllegalArgumentException("Unknown cache object -- use isCached() to check first if appropriate: " + pob + " class: " + pob.getClass());
    }

    public File getSourceFile(Object pob) {
        String path = this.getSourcePath(pob);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public void add(File file, PersistentObject pob, Class cl) {
        this.add(file.getPath(), pob, cl);
    }

    public void add(String path, PersistentObject pob, Class cl) {
        this.add(path, pob, cl, true);
    }

    private void add(String path, PersistentObject pob, Class cl, boolean fireAction) {
        PobBoxModel model;
        PathClass fc = new PathClass(path, cl);
        if (this.fObjectPathStringMap.containsKey(pob)) {
            this.log.debug((Object)("Already cached object: " + pob + " in: " + this.fObjectPathStringMap.get(pob)));
        }
        this.fPathClassObjectMap.put(fc, pob);
        this.fObjectPathStringMap.put(pob, path);
        String cn = cl.getName();
        if (this.fClassNameNodeMap.get(cn) == null) {
            DefaultMutableTreeNode mtr = new DefaultMutableTreeNode(cn);
            this.fClassNameNodeMap.put(cn, mtr);
            this.fTreeModel.insertNodeInto(mtr, this.fRootNode, this.fRootNode.getChildCount());
        }
        DefaultMutableTreeNode objclassNode = (DefaultMutableTreeNode)this.fClassNameNodeMap.get(cn);
        DefaultMutableTreeNode objNode = new DefaultMutableTreeNode(pob, false);
        this.cleanupNode(pob, path, objclassNode);
        objclassNode.add(objNode);
        try {
            if (fireAction) {
                this.fTreeModel.reload(objclassNode);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)t);
        }
        if (this.fClassNameBoxModelMap.get(cn) == null) {
            model = new PobBoxModel();
            this.fClassNameBoxModelMap.put(cn, model);
        }
        if ((model = (PobBoxModel)this.fClassNameBoxModelMap.get(cn)).getIndexOf(pob) == -1) {
            if (fireAction) {
                this.cleanupModel(pob, path, model);
            }
            model.addElement(pob);
            if (fireAction) {
                this.firePathAdded(new PropertyChangeEvent(this, PROP_PATH_ADDED, null, path));
                if (pob instanceof Report) {
                    this.fireReportAdded(new PropertyChangeEvent(this, PROP_REPORT_ADDED, null, pob));
                }
            }
        }
    }

    private void cleanupNode(PersistentObject newpob, String path, DefaultMutableTreeNode node) {
        int i;
        ArrayList<Integer> toremove = new ArrayList<Integer>();
        for (i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode onode = (DefaultMutableTreeNode)node.getChildAt(i);
            PersistentObject pob = (PersistentObject)onode.getUserObject();
            String extant = this.getSourcePath(pob);
            if (extant == null || !extant.equals(path) || !pob.getName().equals(newpob.getName())) continue;
            toremove.add(new Integer(i));
        }
        for (i = 0; i < toremove.size(); ++i) {
            node.remove((Integer)toremove.get(i));
        }
    }

    private void cleanupModel(PersistentObject newpob, String path, PobBoxModel model) {
        int i;
        ArrayList<PersistentObject> toremove = new ArrayList<PersistentObject>();
        for (i = 0; i < model.getSize(); ++i) {
            PersistentObject pob = model.getElementAt(i);
            String extant = this.getSourcePath(pob);
            if (extant == null || !extant.equals(path) || !pob.getName().equals(newpob.getName())) continue;
            toremove.add(pob);
        }
        for (i = 0; i < toremove.size(); ++i) {
            model.removeElement(toremove.get(i));
        }
    }

    public void sortModel(Class cn) {
        Object obj = this.fClassNameBoxModelMap.get(cn.getName());
        if (obj == null) {
            this.log.debug((Object)("no object model yet for class: " + cn));
            return;
        }
        PobBoxModel model = (PobBoxModel)obj;
        model.sort();
    }

    public ComboBoxModel createBoxModel(Class cl) {
        return this.createBoxModel(cl, false);
    }

    public ComboBoxModel createBoxModel(Class cl, boolean addNotSpecifiedObject) {
        PobBoxModel real = this._createBoxModel(cl);
        if (addNotSpecifiedObject) {
            return new ProxyComboBoxModel(real);
        }
        return new ProxyComboBoxModel(real);
    }

    public PobBoxModel _createBoxModel(Class cl) {
        PobBoxModel real;
        Object emodel = this.fClassNameBoxModelMap.get(cl.getName());
        if (emodel != null) {
            real = (PobBoxModel)emodel;
        } else {
            real = new PobBoxModel();
            this.fClassNameBoxModelMap.put(cl.getName(), real);
        }
        return real;
    }

    public void hackAddAuxSets(GeneSetMatrix gm) {
        if (this.auxsetsmodel == null) {
            this.auxsetsmodel = new PobBoxModel();
        }
        for (int i = 0; i < gm.getNumGeneSets(); ++i) {
            this.auxsetsmodel.addElement(gm.getGeneSet(i));
        }
        this.auxsetsmodel.sort();
    }

    public void addPathAdditionsListener(PropertyChangeListener p) {
        this.fPathChanges.addPropertyChangeListener(p);
    }

    private void firePathAdded(PropertyChangeEvent evt) {
        this.fPathChanges.firePropertyChange(evt);
    }

    private void fireReportAdded(PropertyChangeEvent evt) {
        this.fReportChanges.firePropertyChange(evt);
    }

    public void addInvisibly(File file, PersistentObject pob) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        if (pob == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        if (this.fInvisiblePobFileMap.containsKey(pob)) {
            this.log.warn((Object)("Already registered: " + pob.getName() + " overwritting"));
        }
        this.fInvisiblePobFileMap.put(pob, file);
    }

    public void addInvisibly(String source, PersistentObject pob) {
        if (source == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        this.addInvisibly(new File(source), pob);
    }

    class PathClass {
        private String path;
        private Class cl;

        private PathClass(String path, Class cl) {
            if (path == null) {
                throw new IllegalArgumentException("Param path cannot be null");
            }
            if (cl == null) {
                throw new IllegalArgumentException("Param cl cannot be null");
            }
            this.path = path;
            this.cl = cl;
        }

        public boolean equals(Object obj) {
            if (obj instanceof PathClass) {
                return this.equals((PathClass)obj);
            }
            return false;
        }

        public boolean equals(PathClass fc) {
            if (!fc.path.equals(this.path)) {
                return false;
            }
            return fc.cl.getName().equals(this.cl.getName());
            {
            }
        }

        public int hashCode() {
            return this.path.hashCode() + this.cl.getName().hashCode();
        }
    }
}

