/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.Constants;
import edu.mit.broad.msigdb_browser.genome.JarResources;
import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.objects.DataType;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSet;
import edu.mit.broad.msigdb_browser.genome.objects.GeneSetMatrix;
import edu.mit.broad.msigdb_browser.genome.objects.GenesOfInterest;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.reports.api.Report;
import edu.mit.broad.msigdb_browser.genome.utils.SystemUtils;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileView;

public class DataFormat
extends DataType
implements Constants {
    public static final DataFormat XLS_FORMAT = new DataFormat(ExtFormat.class, "Excel", "Microsoft Excel", "xls", JarResources.getIcon("Xls.gif"));
    public static final DataFormat TXT_FORMAT = new DataFormat(ExtFormat.class, "Text", "Plain Text", "txt", JarResources.getIcon("Txt.gif"));
    public static final DataFormat XML_FORMAT = new DataFormat(ExtFormat.class, "XML", "Extensible Markup Language", "xml", JarResources.getIcon("Xml.gif"));
    public static final DataFormat GRP_FORMAT = new DataFormat(GeneSet.class, "GeneSet", "MIT GeneSet Format", "grp", JarResources.getIcon("Grp.gif"));
    public static final DataFormat GMX_FORMAT = new DataFormat(GeneSetMatrix.class, "GeneSetMatrix", "MIT format for a Matrix of Gene Sets", "gmx", JarResources.getIcon("Gmx.png"));
    public static final DataFormat GMT_FORMAT = new DataFormat(GeneSetMatrix.class, "GeneSetMatrix_Transposed", "MIT format for a Matrix of Gene Sets", "gmt", JarResources.getIcon("Gmt.png"));
    public static final DataFormat MSIGDB_FORMAT = new DataFormat(MSigDB.class, "MSigDB", "MSigDB format for a database of gene sets and their annotations", "xml", JarResources.getIcon("Xml.gif"));
    public static final DataFormat RPT_FORMAT = new DataFormat(Report.class, "Report", "Report for a program", "rpt", JarResources.getIcon("Rpt.gif"));
    public static final DataFormat CHIP_FORMAT = new DataFormat(Chip.class, "Chip", "Chip", "chip", JarResources.getIcon("Chip16.png"));
    private static final DataFormat[] ALL = new DataFormat[]{GRP_FORMAT, GMT_FORMAT, GMX_FORMAT, MSIGDB_FORMAT, RPT_FORMAT, CHIP_FORMAT, XLS_FORMAT, TXT_FORMAT, XML_FORMAT};
    public static final DataFormat[] ALL_GENESETMATRIX_FORMATS = new DataFormat[]{GMX_FORMAT, GMT_FORMAT};
    private static final Map kClassExtMap = new HashMap();
    private static final Map kExtDfMap = new HashMap();
    private static final Map kClassIconMap = new HashMap();
    private static final Map kClassNameMap = new HashMap();
    private String fName;
    private String fDesc;
    private Icon fIcon;
    private String fExt;

    public DataFormat() {
    }

    public static FileView getParsableFileView() {
        return new ParsableFileView();
    }

    public static DataFormat getExtension(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        String ext = obj instanceof DataFormat ? ((DataFormat)obj).getExtension() : obj.toString();
        for (int i = 0; i < ALL.length; ++i) {
            if (ALL[i].getExtension().equalsIgnoreCase(ext)) {
                return ALL[i];
            }
            if (!ALL[i].toString().equalsIgnoreCase(ext)) continue;
            return ALL[i];
        }
        throw new IllegalArgumentException("No DataFormat found for: " + ext);
    }

    public DataFormat(Class repClass, String name, String desc, String ext, Icon icon) throws IllegalArgumentException {
        super(repClass, ext);
        if (name == null) {
            throw new IllegalArgumentException("Param name cannot be null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("Param desc cannot be null");
        }
        if (!SystemUtils.isHeadless() && icon == null) {
            throw new IllegalArgumentException("Param icon cannot be null");
        }
        if (ext == null) {
            throw new IllegalArgumentException("Null extension is not allowed: " + ext);
        }
        if (ext.startsWith(".")) {
            throw new IllegalArgumentException("DataFormat extension cannot begin with a period '.' " + ext);
        }
        if (ext.length() <= 0) {
            throw new IllegalArgumentException("DataFormat extension cannot have zero length " + ext);
        }
        this.fExt = ext;
        this.fIcon = icon;
        this.fName = name;
        this.fDesc = desc;
    }

    public String getName() {
        return this.fName;
    }

    public String getDesc() {
        return this.fDesc;
    }

    public String getExtension() {
        return this.fExt;
    }

    public Icon getIcon() {
        return this.fIcon;
    }

    @Override
    public String toString() {
        return new StringBuffer(this.getName()).append("[").append(this.getExtension()).append("]").toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DataFormat) {
            return ((DataFormat)obj).fExt.equals(this.fExt);
        }
        return this.fExt.equalsIgnoreCase(obj.toString());
    }

    public static DataFormat getDataFormat(String ext) {
        Object obj = kExtDfMap.get(ext);
        if (obj != null) {
            return (DataFormat)obj;
        }
        return null;
    }

    public static Icon getIcon(String ext) {
        DataFormat df = DataFormat.getDataFormat(ext);
        if (df != null) {
            return df.getIcon();
        }
        return JarResources.ICON_UNKNOWN_DATA_FORMAT;
    }

    public static Icon getIconOrNull(String ext) {
        DataFormat df = DataFormat.getDataFormat(ext);
        if (df != null) {
            return df.getIcon();
        }
        return null;
    }

    public static String getDesc(File file) {
        String ext = NamingConventions.getExtension(file).toLowerCase();
        DataFormat df = DataFormat.getDataFormat(ext);
        if (df != null) {
            return df.getDesc();
        }
        return null;
    }

    public static Icon getIcon(Object obj) {
        if (obj == null) {
            return JarResources.ICON_NOT_FOUND;
        }
        if (obj instanceof File) {
            return DataFormat.getIcon(NamingConventions.getExtension((File)obj));
        }
        if (obj instanceof String) {
            return DataFormat.getIcon(NamingConventions.getExtension(obj.toString()));
        }
        Object ic = kClassIconMap.get(obj.getClass());
        if (ic == null && obj instanceof PersistentObject) {
            Class repcl = DataFormat.getRepresentationClass((PersistentObject)obj);
            ic = kClassIconMap.get(repcl);
        }
        if (ic == null) {
            return JarResources.ICON_NOT_FOUND;
        }
        return (Icon)ic;
    }

    public static Class getRepresentationClass(PersistentObject pob) {
        if (pob instanceof GenesOfInterest) {
            return GenesOfInterest.class;
        }
        if (pob instanceof GeneSet) {
            return GeneSet.class;
        }
        if (pob instanceof GeneSetMatrix) {
            return GeneSetMatrix.class;
        }
        if (pob instanceof Report) {
            return Report.class;
        }
        if (pob instanceof Chip) {
            return Chip.class;
        }
        if (pob instanceof MSigDB) {
            return MSigDB.class;
        }
        throw new IllegalArgumentException("Unknown object: " + pob);
    }

    public static Icon getIconOrNull(File file) {
        String ext = NamingConventions.getExtension(file).toLowerCase();
        return DataFormat.getIconOrNull(ext);
    }

    public static boolean isCompatibleRepresentationClass(Object obj, Class cl) {
        if (obj == null) {
            throw new IllegalArgumentException("Parameter obj cannot be null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("Parameter cl cannot be null");
        }
        if (obj.getClass().getName().equals(cl.getName())) {
            return true;
        }
        Class<?>[] interfacesA = obj.getClass().getInterfaces();
        for (int i = 0; i < interfacesA.length; ++i) {
            if (!cl.getName().equals(interfacesA[i].getName())) continue;
            return true;
        }
        Class<?>[] interfacesB = cl.getInterfaces();
        for (int i = 0; i < interfacesB.length; ++i) {
            if (!obj.getClass().getName().equals(interfacesB[i].getName())) continue;
            return true;
        }
        for (int a = 0; a < interfacesA.length; ++a) {
            for (int b = 0; b < interfacesB.length; ++b) {
                if (!interfacesA[a].getName().equals(interfacesB[b].getName())) continue;
                return true;
            }
        }
        return obj instanceof GeneSetMatrix;
    }

    static {
        for (int i = 0; i < ALL.length; ++i) {
            kExtDfMap.put(ALL[i].getExtension(), ALL[i]);
            Class<?> repClass = ALL[i].getRepresentationClass();
            if (ExtFormat.class.isAssignableFrom(repClass)) continue;
            if (!kClassNameMap.containsKey(repClass)) {
                kClassNameMap.put(ALL[i].getRepresentationClass(), ALL[i].getName());
            }
            if (!kClassExtMap.containsKey(repClass)) {
                kClassExtMap.put(ALL[i].getRepresentationClass(), ALL[i].getExtension());
            }
            if (kClassIconMap.containsKey(repClass)) continue;
            kClassIconMap.put(ALL[i].getRepresentationClass(), ALL[i].getIcon());
        }
    }

    private class ExtFormat {
        private ExtFormat() {
        }
    }

    static class ParsableFileView
    extends FileView {
        ParsableFileView() {
        }

        @Override
        public Icon getIcon(File file) {
            return DataFormat.getIconOrNull(file);
        }

        @Override
        public String getTypeDescription(File file) {
            return null;
        }

        @Override
        public String getDescription(File file) {
            return DataFormat.getDesc(file);
        }
    }
}

