/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.parsers;

import edu.mit.broad.msigdb_browser.genome.NamingConventions;
import edu.mit.broad.msigdb_browser.genome.objects.PersistentObject;
import edu.mit.broad.msigdb_browser.genome.parsers.AbstractParser;
import edu.mit.broad.msigdb_browser.genome.parsers.ParseUtils;
import edu.mit.broad.msigdb_browser.genome.parsers.ParserException;
import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import edu.mit.broad.msigdb_browser.vdb.chip.Chip;
import edu.mit.broad.msigdb_browser.vdb.chip.FileInMemoryChip;
import edu.mit.broad.msigdb_browser.vdb.chip.Probe;
import edu.mit.broad.msigdb_browser.vdb.chip.SimpleProbe;
import edu.mit.broad.msigdb_browser.vdb.chip.SimpleProbe2;
import edu.mit.broad.msigdb_browser.vdb.chip.SimpleProbe3;
import edu.mit.broad.msigdb_browser.vdb.meg.AliasDb;
import edu.mit.broad.msigdb_browser.vdb.meg.Gene;
import gnu.trove.THashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class ChipParser
extends AbstractParser {
    private static final String PROBE_SET_ID = "Probe Set ID";
    private static final String GENE_TITLE = "Gene Title";
    private static final String GENE_SYMBOL = "Gene Symbol";
    private static final String ALIASES = "Aliases";
    private static final String TAXON = "Taxon ID";

    public ChipParser() {
        super(Chip.class);
    }

    @Override
    public void export(PersistentObject pob, File file) throws Exception {
        this.export((Chip)pob, file, true);
    }

    public void export(Chip chip, File file, boolean withTitles) throws Exception {
        String[] colNames = withTitles ? new String[]{PROBE_SET_ID, GENE_SYMBOL, GENE_TITLE} : new String[]{PROBE_SET_ID, GENE_SYMBOL};
        PrintWriter pw = new PrintWriter(new FileOutputStream(file));
        for (int i = 0; i < colNames.length; ++i) {
            pw.print(colNames[i]);
            if (i == colNames.length) continue;
            pw.print('\t');
        }
        pw.println();
        for (int r = 0; r < chip.getNumProbes(); ++r) {
            Probe probe = chip.getProbe(r);
            pw.print(probe.getName());
            pw.print('\t');
            Gene gene = probe.getGene();
            String symbol = null;
            String title = null;
            if (gene != null) {
                symbol = gene.getSymbol();
                title = gene.getTitle();
            }
            if (symbol == null) {
                symbol = "NULL";
            }
            if (title == null) {
                title = "NULL";
            }
            pw.print(symbol);
            if (withTitles) {
                pw.print('\t');
                pw.print(title);
            }
            pw.println();
        }
        pw.close();
        this.doneExport();
    }

    @Override
    public List parse(String sourcepath, InputStream is) throws Exception {
        String sp_tmp = sourcepath.toUpperCase();
        if (sp_tmp.indexOf("UNIGENE") != -1 || sp_tmp.indexOf("GENE_SYMBOL") != -1) {
            return this._parse_from_unigene_or_gene_symbol(sourcepath, is);
        }
        if (sp_tmp.indexOf("SEQ_ACCESSION") != -1) {
            return this._parse_from_seq_accession(sourcepath, is);
        }
        if (sourcepath.endsWith("chip")) {
            return this._parse_from_dot_chip(sourcepath, is);
        }
        if (sourcepath.endsWith("csv")) {
            return this._parse_from_csv(sourcepath, is);
        }
        throw new IllegalArgumentException("Unknown chip file type for parsing: " + sourcepath);
    }

    private List _parse_from_csv(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        List colHeaders = ParseUtils.string2stringsList_csv(currLine);
        int ps_index = ChipParser.indexOf(PROBE_SET_ID, colHeaders, true);
        int symbol_index = ChipParser.indexOf(GENE_SYMBOL, colHeaders, true);
        int title_index = ChipParser.indexOf(GENE_TITLE, colHeaders, true);
        THashSet probes = new THashSet();
        currLine = this.nextLine(bin);
        while (currLine != null) {
            String[] fields = ParseUtils.string2strings_csv(currLine);
            String symbol = fields[symbol_index];
            String title = fields[title_index];
            symbol = NamingConventions.symbolize(symbol);
            if (title.equals("---")) {
                title = null;
            }
            SimpleProbe probe = new SimpleProbe(fields[ps_index], symbol, title);
            probes.add(probe);
            currLine = this.nextLine(bin);
        }
        Probe[] keeps = probes.toArray(new Probe[probes.size()]);
        FileInMemoryChip chip = new FileInMemoryChip(FilenameUtils.getName((String)sourcepath), sourcepath, keeps);
        bin.close();
        this.doneImport();
        return ChipParser.unmodlist(chip);
    }

    private boolean isSymbolProbes(String sourcepath) {
        return sourcepath.indexOf("Gene_Symbol") != -1;
    }

    private List _parse_from_unigene_or_gene_symbol(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        boolean isSymbolProbes = this.isSymbolProbes(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        List colHeaders = ParseUtils.string2stringsList(currLine, "\t");
        int ps_index = ChipParser.indexOf(PROBE_SET_ID, colHeaders, true);
        int symbol_index = ChipParser.indexOf(GENE_SYMBOL, colHeaders, true);
        int title_index = ChipParser.indexOf(GENE_TITLE, colHeaders, true);
        int alias_index = ChipParser.indexOf(ALIASES, colHeaders, false);
        ArrayList<SimpleProbe3> probesList = new ArrayList<SimpleProbe3>();
        currLine = this.nextLine(bin);
        HashSet<String> symbols = new HashSet<String>();
        while (currLine != null) {
            String[] fields = ParseUtils.string2stringsV2(currLine);
            if (fields.length != 3 && fields.length != 4) {
                throw new ParserException("Bad format expecting 3 or 4 fields but found: " + fields.length + "\nOn line >" + currLine + "<");
            }
            String probeName = fields[ps_index];
            if (isSymbolProbes) {
                probeName = NamingConventions.symbolize(probeName);
            }
            if (probeName != null && !symbols.contains(probeName)) {
                String symbol = fields[symbol_index];
                String title = fields[title_index];
                symbol = NamingConventions.symbolize(symbol);
                if (title != null && title.equals("---")) {
                    title = null;
                }
                Set aliases = null;
                if (alias_index != -1 && alias_index < fields.length) {
                    aliases = ParseUtils.string2stringsSet(fields[alias_index], "\u001c", false);
                }
                SimpleProbe3 probe = new SimpleProbe3(symbol, title, aliases);
                probesList.add(probe);
                symbols.add(symbol);
            }
            currLine = this.nextLine(bin);
        }
        Probe[] probes = probesList.toArray(new SimpleProbe3[probesList.size()]);
        for (int i = 0; i < probes.length; ++i) {
            probes[i].removeAnyAliasesThatMatch(symbols);
        }
        FileInMemoryChip chip = new FileInMemoryChip(FilenameUtils.getName((String)sourcepath), sourcepath, probes);
        bin.close();
        this.log.info((Object)("Parsed from unigene / gene symbol: " + probes.length));
        this.doneImport();
        return ChipParser.unmodlist(chip);
    }

    private List _parse_from_dot_chip(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        List colHeaders = ParseUtils.string2stringsList(currLine, "\t");
        int ps_index = ChipParser.indexOf(PROBE_SET_ID, colHeaders, true);
        int symbol_index = ChipParser.indexOf(GENE_SYMBOL, colHeaders, true);
        int title_index = ChipParser.indexOf(GENE_TITLE, colHeaders, true);
        ArrayList<SimpleProbe> probesList = new ArrayList<SimpleProbe>();
        currLine = this.nextLine(bin);
        HashSet<String> names = new HashSet<String>();
        while (currLine != null) {
            String[] fields = ParseUtils.string2strings(currLine, "\t", true);
            String probeName = fields[ps_index];
            if (probeName != null && !names.contains(probeName)) {
                String symbol = fields[symbol_index];
                symbol = NamingConventions.symbolize(symbol);
                String title = null;
                try {
                    title = fields[title_index];
                    if (title != null && title.equals("---")) {
                        title = null;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                SimpleProbe probe = new SimpleProbe(probeName, symbol, title);
                probesList.add(probe);
            }
            if (probeName != null) {
                names.add(probeName);
            }
            currLine = this.nextLine(bin);
        }
        Probe[] probes = probesList.toArray(new Probe[probesList.size()]);
        FileInMemoryChip chip = new FileInMemoryChip(FilenameUtils.getName((String)sourcepath), sourcepath, probes);
        bin.close();
        this.log.info((Object)("Parsed from dotchip : " + probes.length));
        this.doneImport();
        return ChipParser.unmodlist(chip);
    }

    private List _parse_from_seq_accession(String sourcepath, InputStream is) throws Exception {
        this.startImport(sourcepath);
        BufferedReader bin = new BufferedReader(new InputStreamReader(is));
        String currLine = this.nextLine(bin);
        List colHeaders = ParseUtils.string2stringsList(currLine, "\t");
        int ps_index = ChipParser.indexOf(PROBE_SET_ID, colHeaders, true);
        int symbol_index = ChipParser.indexOf(GENE_SYMBOL, colHeaders, true);
        Chip chip_gene_symbol = VdbRuntimeResources.getChip_Gene_Symbol();
        ArrayList<Probe> probes = new ArrayList<Probe>();
        HashSet<String> probeNamesAdded = new HashSet<String>();
        for (int i = 0; i < chip_gene_symbol.getNumProbes(); ++i) {
            probes.add(chip_gene_symbol.getProbe(i));
            probeNamesAdded.add(chip_gene_symbol.getProbe(i).getName());
        }
        this.log.debug((Object)("# of seq probes (from symbol): " + probes.size()));
        currLine = this.nextLine(bin);
        while (currLine != null) {
            String[] fields = ParseUtils.string2strings(currLine, "\t", true);
            String symbol = NamingConventions.symbolize(fields[symbol_index]);
            String probeName = fields[ps_index];
            if (!probeNamesAdded.contains(probeName)) {
                probeNamesAdded.add(probeName);
                SimpleProbe2 probe = new SimpleProbe2(probeName, symbol, chip_gene_symbol);
                probes.add(probe);
            }
            currLine = this.nextLine(bin);
        }
        this.log.debug((Object)("# of seq probes: " + probes.size()));
        AliasDb aliasdb = VdbRuntimeResources.getAliasDb();
        Probe[] alias_probes = aliasdb.getAliasesAsProbes();
        for (int i = 0; i < alias_probes.length; ++i) {
            if (probeNamesAdded.contains(alias_probes[i].getName())) continue;
            probes.add(alias_probes[i]);
        }
        this.log.debug((Object)("FINAL # of seq probes: " + probes.size()));
        Probe[] keeps = probes.toArray(new Probe[probes.size()]);
        FileInMemoryChip chip = new FileInMemoryChip(FilenameUtils.getName((String)sourcepath), sourcepath, keeps);
        bin.close();
        this.log.info((Object)("Parser from Seq_Accession: " + keeps.length));
        this.doneImport();
        return ChipParser.unmodlist(chip);
    }
}

