/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.models;

import edu.mit.broad.msigdb_browser.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.msigdb_browser.vdb.msigdb.MSigDB;
import javax.swing.table.AbstractTableModel;

public class MSigDBModel
extends AbstractTableModel {
    private MSigDB fMSigDB;
    public static final int COL_PUBMEDID = 10;
    private static String[] COL_NAMES = new String[]{"", "NAME", "# GENES", "DESCRIPTION", "COLLECTION", "ORGANISM", "CHIP", "CONTRIBUTER", "PUBMED ID", "EXTERNAL URL"};

    public MSigDBModel(MSigDB msigdb) {
        if (msigdb == null) {
            throw new IllegalArgumentException("Param msigdb cannot be null");
        }
        this.fMSigDB = msigdb;
    }

    public MSigDB getMSigDB() {
        return this.fMSigDB;
    }

    @Override
    public int getColumnCount() {
        return COL_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.fMSigDB.getNumGeneSets();
    }

    @Override
    public String getColumnName(int col) {
        return COL_NAMES[col];
    }

    @Override
    public Object getValueAt(int row, int col) {
        GeneSetAnnotation ann = this.fMSigDB.getGeneSetAnnotation(row);
        if (col == 0) {
            return "" + (row + 1);
        }
        if (col == 1) {
            return ann.getStandardName();
        }
        if (col == 2) {
            return "" + ann.getGeneSet(true).getNumMembers();
        }
        if (col == 3) {
            return ann.getDescription().getBrief();
        }
        if (col == 4) {
            return ann.getCategory().getName();
        }
        if (col == 5) {
            return ann.getOrganism().toString();
        }
        if (col == 6) {
            return ann.getChipOriginal_name();
        }
        if (col == 7) {
            return ann.getContributor().getName();
        }
        if (col == 8) {
            return ann.getExternalLinks().getPMID();
        }
        if (col == 9) {
            return ann.getExternalLinks().getExtDetailsURL();
        }
        return "huh";
    }

    public Class getColumnClass(int col) {
        Class cl = col == 0 || col == 3 ? Integer.class : String.class;
        return cl;
    }

    public boolean isEditable() {
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

