/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome.alg;

import edu.mit.broad.msigdb_browser.vdb.VdbRuntimeResources;
import java.util.Comparator;
import org.apache.commons.io.FilenameUtils;

public class ComparatorFactory {
    private ComparatorFactory() {
    }

    public static class ChipNameComparator
    implements Comparator {
        public int compare(Object pn1, Object pn2) {
            String s1 = pn1.toString();
            String s2 = pn2.toString();
            if (VdbRuntimeResources.isChipGeneSymbol(s1) && VdbRuntimeResources.isChipGeneSymbol(s2)) {
                return 0;
            }
            if (VdbRuntimeResources.isChipGeneSymbol(s1)) {
                return -1;
            }
            if (VdbRuntimeResources.isChipGeneSymbol(s2)) {
                return 1;
            }
            if (VdbRuntimeResources.isChipSeqAccession(s1) && VdbRuntimeResources.isChipGeneSymbol(s2)) {
                return 0;
            }
            if (VdbRuntimeResources.isChipSeqAccession(s1)) {
                return -1;
            }
            if (VdbRuntimeResources.isChipSeqAccession(s2)) {
                return 1;
            }
            if (s1.toUpperCase().startsWith("HG") && s2.toUpperCase().startsWith("HG")) {
                return s1.compareTo(s2);
            }
            if (s1.toUpperCase().startsWith("HG")) {
                return -1;
            }
            if (s2.toUpperCase().startsWith("HG")) {
                return 1;
            }
            if (s1.toUpperCase().startsWith("HU") && s2.toUpperCase().startsWith("HU")) {
                return s1.compareTo(s2);
            }
            if (s1.toUpperCase().startsWith("HU")) {
                return -1;
            }
            if (s2.toUpperCase().startsWith("HU")) {
                return 1;
            }
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }

    public static class FileExtComparator
    implements Comparator {
        public int compare(Object pn1, Object pn2) {
            String ext1 = FilenameUtils.getExtension((String)pn1.toString());
            String ext2 = FilenameUtils.getExtension((String)pn2.toString());
            return ext1.compareTo(ext2);
        }

        @Override
        public boolean equals(Object o2) {
            return false;
        }
    }
}

