/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.msigdb_browser.genome;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class NamingConventions {
    private static final int MAX_FILE_LEN_ALLOWED = 100;

    public static boolean isURL(String path) {
        return path.toLowerCase().startsWith("http") || path.toLowerCase().startsWith("www") || path.toLowerCase().startsWith("ftp");
    }

    public static String titleize(String title) {
        if (NamingConventions.isNull(title)) {
            return "NULL";
        }
        if (title.startsWith("\"")) {
            title = title.substring(1, title.length());
        }
        if (title.endsWith("\"")) {
            title = title.substring(0, title.length() - 1);
        }
        return title;
    }

    public static String symbolize(String symbol) {
        if (symbol == null) {
            return null;
        }
        if ((symbol = symbol.trim()).equals("---") || symbol.equalsIgnoreCase("NULL") || symbol.length() == 0) {
            return null;
        }
        if ((symbol = symbol.toUpperCase()).length() > 20) {
            return symbol.substring(0, 20).trim();
        }
        return symbol;
    }

    public static String createNiceEnglishDate_for_dirs() {
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("MMM");
        String s = formatter.format((Object)date);
        formatter = new SimpleDateFormat("dd");
        s = (s + formatter.format((Object)date)).toLowerCase();
        return s;
    }

    public static boolean isNull(String s) {
        if (s == null) {
            return true;
        }
        if ((s = s.trim()).length() == 0) {
            return true;
        }
        if (s.equalsIgnoreCase("na")) {
            return true;
        }
        return s.equalsIgnoreCase("NULL");
    }

    public static String removeExtension(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Param fileName cannot be null");
        }
        if (fileName.indexOf(".") == -1) {
            return fileName;
        }
        if (fileName.indexOf(35) != -1) {
            return fileName;
        }
        if (fileName.endsWith(".")) {
            return fileName.substring(0, fileName.length() - 1);
        }
        int index = fileName.lastIndexOf(46);
        if (-1 == index) {
            return fileName;
        }
        String just_name = fileName.substring(0, index);
        String ext = fileName.substring(index + 1, fileName.length());
        if (ext.length() <= 4) {
            return just_name;
        }
        StringTokenizer tok = new StringTokenizer(ext, "_");
        tok.nextToken();
        StringBuffer extra = new StringBuffer("_");
        while (tok.hasMoreElements()) {
            extra.append(tok.nextToken());
            if (!tok.hasMoreElements()) continue;
            extra.append("_");
        }
        if (extra.length() != 1) {
            return just_name + extra;
        }
        return just_name;
    }

    public static File createSafeFile(File inDir, String name) {
        return new File(inDir, NamingConventions.createSafeFileName(name));
    }

    public static String createSafeFileName(String name) {
        name = name.trim();
        Object safename = name.replace('@', '_');
        safename = ((String)safename).replace('#', '_');
        safename = ((String)safename).replace(' ', '_');
        safename = ((String)safename).replace('%', '_');
        safename = ((String)safename).replace('$', '_');
        safename = ((String)safename).replace(':', '_');
        safename = ((String)safename).replace('*', '_');
        safename = ((String)safename).replace('\\', '_');
        safename = ((String)safename).replace('/', '_');
        if (((String)(safename = ((String)safename).replace('\u001c', '_'))).length() >= 100) {
            String ext = NamingConventions.getExtension((String)safename);
            safename = ((String)safename).substring(0, 100) + "." + ext;
        }
        return safename;
    }

    public static String getExtension(String f) {
        int pos = f.lastIndexOf(".");
        String ext = pos == -1 ? "" : f.substring(pos + 1);
        if (f.indexOf(".meta.") != -1) {
            return "meta." + ext;
        }
        return ext;
    }

    public static String getExtension(File f) {
        return NamingConventions.getExtension(f.getName());
    }

    public static String getExtensionLiberal(String f) {
        String ext;
        int pos = f.lastIndexOf(".");
        if (pos == -1) {
            ext = "";
        } else {
            int pos2;
            if (pos > 0 && (pos2 = f.lastIndexOf(".", pos - 1)) != -1) {
                String ext2 = f.substring(pos2 + 1, pos);
                if (ext2.equalsIgnoreCase("gct")) {
                    return "gct";
                }
                if (ext2.equalsIgnoreCase("res")) {
                    return "res";
                }
                if (ext2.equalsIgnoreCase("pcl")) {
                    return "pcl";
                }
                if (ext2.equalsIgnoreCase("gmx")) {
                    return "gmx";
                }
                if (ext2.equalsIgnoreCase("gmt")) {
                    return "gmt";
                }
                if (ext2.equalsIgnoreCase("rnk")) {
                    return "rnk";
                }
                if (ext2.equalsIgnoreCase("cls")) {
                    return "cls";
                }
            }
            ext = f.substring(pos + 1);
        }
        return ext;
    }
}

