/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.swing.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jfree.ui.SortableTable;
import org.jfree.ui.SortableTableModel;

public class ViewAndSearchComponent
extends JPanel {
    private SortableTable sortableTable;
    private ControlPanel controlPanel;

    public ViewAndSearchComponent(String runBtnText, SortableTableModel tableModel, ActionListener runListener, ActionListener reportListener) {
        this.sortableTable = new SortableTable(tableModel){

            public String getToolTipText(MouseEvent event) {
                Object obj;
                String tip = null;
                Point p = event.getPoint();
                int hitColumnIndex = this.columnAtPoint(p);
                int hitRowIndex = this.rowAtPoint(p);
                if (hitColumnIndex != -1 && hitRowIndex != -1 && (obj = this.getValueAt(hitRowIndex, hitColumnIndex)) != null) {
                    tip = obj.toString();
                }
                if (tip == null) {
                    tip = this.getToolTipText();
                }
                return tip;
            }
        };
        this.sortableTable.getSelectionModel().setSelectionMode(2);
        JScrollPane scrollPane = new JScrollPane((Component)this.sortableTable, 22, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.controlPanel = new ControlPanel(runBtnText, runListener, reportListener, this.sortableTable);
        this.add((Component)this.controlPanel, "South");
    }

    public TableSelectionListener getTableSelectionListener() {
        return this.controlPanel.tableSelectionListener;
    }

    public String[] getSelectedColumnArray(int columnIndex) {
        int[] rows = this.sortableTable.getSelectedRows();
        String[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            names[i] = this.sortableTable.getModel().getValueAt(rows[i], columnIndex).toString();
        }
        return names;
    }

    public SortableTable getTable() {
        return this.sortableTable;
    }

    public JPanel getButtonPanel() {
        return this.controlPanel;
    }

    static class ControlPanel
    extends JPanel {
        private JButton bLeadingEdge;
        private JButton buildhtmlReportBtn;
        private TableSelectionListener tableSelectionListener;
        private JLabel label;

        public ControlPanel(String runBtnText, ActionListener runListener, ActionListener reportListener, final SortableTable table) {
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 20, 10));
            JButton bHelp = JarResources.createHelpButton("Interpret-Leading-Edge");
            GridBagConstraints gbc1 = new GridBagConstraints();
            gbc1.gridheight = 1;
            gbc1.gridwidth = 4;
            gbc1.gridx = 0;
            gbc1.gridy = 0;
            gbc1.weightx = 0.25;
            gbc1.fill = 0;
            gbc1.anchor = 17;
            this.add((Component)bHelp, gbc1);
            JPanel subPanel = new JPanel(new FlowLayout());
            GridBagConstraints gbc2 = new GridBagConstraints();
            gbc2.gridheight = 1;
            gbc2.gridwidth = 4;
            gbc2.gridx = 3;
            gbc2.gridy = 0;
            gbc2.fill = 0;
            gbc2.anchor = 13;
            gbc2.weightx = 0.25;
            this.add((Component)subPanel, gbc2);
            this.label = new JLabel("For " + table.getSelectedRows().length + " selected gene sets: ");
            table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    label.setText("For " + table.getSelectedRows().length + " selected gene sets: ");
                }
            });
            subPanel.add(this.label);
            this.bLeadingEdge = new JButton(runBtnText, GuiHelper.ICON_START16);
            this.bLeadingEdge.addActionListener(runListener);
            this.bLeadingEdge.setEnabled(false);
            this.tableSelectionListener = new TableSelectionListener(table);
            table.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
            this.tableSelectionListener.addComponent(this.bLeadingEdge);
            subPanel.add(this.bLeadingEdge);
            this.buildhtmlReportBtn = new JButton("Build HTML Report", GuiHelper.ICON_START16);
            this.buildhtmlReportBtn.addActionListener(reportListener);
            this.buildhtmlReportBtn.setEnabled(false);
            this.tableSelectionListener.addComponent(this.buildhtmlReportBtn);
            subPanel.add(this.buildhtmlReportBtn);
        }
    }

    private static class TableSelectionListener
    implements ListSelectionListener {
        private SortableTable table;
        private List list;

        public TableSelectionListener(SortableTable table) {
            table.getSelectionModel().addListSelectionListener(this);
            this.table = table;
            this.list = new ArrayList();
        }

        public void addComponent(Component c) {
            this.list.add(c);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean enabled = this.table.getSelectedRows().length >= 2;
            int size = this.list.size();
            for (int i = 0; i < size; ++i) {
                ((Component)this.list.get(i)).setEnabled(enabled);
            }
        }
    }
}

