/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.ext;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.Icon;

public class OsExplorerAction
extends ExtAction {
    private boolean registerOnComplete = false;

    public OsExplorerAction() {
        super("OsExplorerAction", "File Explorer", "Launch FileExplorer in an External Process", JarResources.getIcon("OsExplorer16.gif"), null);
    }

    public OsExplorerAction(String name, String description, Icon icon, File path) {
        super("OsExplorerAction", name, description, icon, path);
    }

    public OsExplorerAction(File file) {
        this();
        this.setPath(file);
    }

    public void setRegisterOnComplete() {
        this.registerOnComplete = true;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        File file = this.getPath();
        if (file == null) {
            return;
        }
        try {
            File dir = file.isDirectory() ? file : file.getParentFile();
            URI outputDirURI = dir.toURI();
            outputDirURI = new URI(outputDirURI.getScheme(), "", outputDirURI.getPath(), null, null);
            Desktop.getDesktop().browse(outputDirURI);
            if (this.registerOnComplete) {
                Application.getFileManager().registerRecentlyOpenedURL(dir.getPath());
            }
        }
        catch (Throwable t) {
            Application.getWindowManager().showError("Trouble launching File Explorer on path '" + file.getPath() + "'", t);
        }
    }
}

