/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Template;

public class VectorSplitter {
    private int numtested;
    private int numtoofewA;
    private int numtoofewB;
    private int minNumNanlessPointsNeeded;

    public VectorSplitter(int minNumNanlessPointsNeeded) {
        this.minNumNanlessPointsNeeded = minNumNanlessPointsNeeded;
    }

    public Vector[] splitBiphasic_nansafe(Vector profile, Template template) {
        Vector[] vs = template.splitByTemplateClass(profile);
        if (vs.length != 2) {
            VectorSplitter._barf_not_biphasic(template, vs);
        }
        ++this.numtested;
        vs[0] = vs[0].toVectorNaNless();
        vs[1] = vs[1].toVectorNaNless();
        if (vs[0].getSize() < this.minNumNanlessPointsNeeded) {
            ++this.numtoofewA;
            return null;
        }
        if (vs[1].getSize() < this.minNumNanlessPointsNeeded) {
            ++this.numtoofewB;
            return null;
        }
        return vs;
    }

    private static String _barf_not_biphasic(Template template, Vector[] vs) {
        StringBuffer buf = new StringBuffer("Template is not biphasic. Name: " + template.getName() + " # splits= " + vs.length);
        buf.append("\n<br>This metric can only be used with 2 class comparisons");
        throw new RuntimeException(buf.toString());
    }

    public Vector[] splitBiphasic(Vector profile, Template template) {
        Vector[] vs = template.splitByTemplateClass(profile);
        if (vs.length != 2) {
            VectorSplitter._barf_not_biphasic(template, vs);
        }
        if (vs[0] == null) {
            throw new IllegalArgumentException("Split vector 0 is null");
        }
        if (vs[1] == null) {
            throw new IllegalArgumentException("Split vector 1 is null");
        }
        return vs;
    }
}

