/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.cytoscape;

import edu.mit.broad.cytoscape.EnrichmentMapParameters;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CytoscapeCyrest {
    private static final Logger klog = LoggerFactory.getLogger(CytoscapeCyrest.class);
    private EnrichmentMapParameters params;

    public CytoscapeCyrest(EnrichmentMapParameters params) {
        this.params = params;
    }

    private String getRestURL() throws IOException {
        return "http://localhost:" + XPreferencesFactory.kCytoscapeRESTPort.getInt() + "/v1/";
    }

    public boolean CytoscapeRestActive() throws IOException, URISyntaxException {
        URL url = URI.create(this.getRestURL()).toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn.getResponseCode() != 200) {
            klog.error("cannot connect to cytoscape rest server");
            conn.disconnect();
            return false;
        }
        klog.info("successfully connected to cytoscape rest");
        conn.disconnect();
        return true;
    }

    public boolean CytoscapeRestCommandEM() throws IOException, URISyntaxException {
        String line;
        URL url = URI.create(this.getRestURL() + "commands/").toURL();
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (conn.getResponseCode() != 200) {
            throw new IOException(conn.getResponseMessage());
        }
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        while ((line = rd.readLine()) != null) {
            if (!line.contains("enrichmentmap")) continue;
            conn.disconnect();
            klog.info("Found enrichment map command");
            return true;
        }
        rd.close();
        conn.disconnect();
        return false;
    }

    public boolean createEM_get() throws IOException, URISyntaxException {
        URIBuilder builder = new URIBuilder();
        builder.setScheme("http").setHost("localhost:1234/v1").setPath("/commands/enrichmentmap/gseabuild").setParameter("edbdir", this.params.getEdbdir()).setParameter("pvalue", Double.toString(this.params.getPvalue())).setParameter("qvalue", Double.toString(this.params.getQvalue())).setParameter("overlap", Double.toString(this.params.getSimilarityCutOff())).setParameter("similaritymetric", this.params.getSimilarityMetric()).setParameter("combinedconstant", Double.toString(this.params.getCombinedConstant()));
        if (!this.params.getExpressionFilePath().equals("")) {
            builder.setParameter("expressionfile", this.params.getExpressionFilePath());
        }
        if (this.params.getEdbdir2() != null && !this.params.getEdbdir2().equalsIgnoreCase("")) {
            builder.setParameter("edbdir2", this.params.getEdbdir2());
            if (!this.params.getExpression2FilePath().equals("")) {
                builder.setParameter("expressionfile2", this.params.getExpression2FilePath());
            }
        }
        URI uri = builder.build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(uri);
        klog.info("Get URL: {}", (Object)httpget.getURI());
        CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpget);
        HttpEntity entity = response.getEntity();
        StatusLine statusLine = response.getStatusLine();
        klog.info("status: {}", (Object)statusLine.getReasonPhrase());
        if (!statusLine.getReasonPhrase().equalsIgnoreCase("ok")) {
            String message = EntityUtils.toString((HttpEntity)entity);
            Application.getWindowManager().showMessage("Unable to create Enrichment Map: " + statusLine.getReasonPhrase() + "\n" + message);
            httpclient.close();
            return false;
        }
        httpclient.close();
        return true;
    }
}

