/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.util.Properties;
import javax.swing.LookAndFeel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.lang3.SystemUtils;
import org.broad.gsea.ui.DesktopIntegration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import xapps.gsea.GseaFijiTabsApplicationFrame;

public class Main {
    private static final Logger klog = LoggerFactory.getLogger(Main.class);
    private static final Properties buildProps = JarResources.getBuildInfo();

    public Main() {
        this.setLnF();
        GseaFijiTabsApplicationFrame frame = new GseaFijiTabsApplicationFrame();
        try {
            frame.init_bg_while_splashing();
        }
        catch (Throwable t) {
            System.out.println("Error while initializing .., things may not work");
            t.printStackTrace();
        }
        frame.makeVisible();
    }

    public static void main(String[] args) {
        try {
            new Main();
        }
        catch (Throwable e) {
            e.printStackTrace();
            klog.error(MarkerFactory.getMarker((String)"FATAL"), "Could not create application", e);
        }
    }

    public void setLnF() {
        try {
            UIManager.put("ClassLoader", LookUtils.class.getClassLoader());
            try {
                if (!SystemUtils.IS_OS_MAC_OSX) {
                    PlasticXPLookAndFeel.setMyCurrentTheme((PlasticTheme)new ExperienceBlue());
                    UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            UIManager.put("Application.useSystemFontSettings", Boolean.TRUE);
            Options.setUseSystemFonts((boolean)true);
            ToolTipManager.sharedInstance().setEnabled(true);
            ToolTipManager.sharedInstance().setDismissDelay(15000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        DesktopIntegration.setDockIcon(JarResources.getImage("icon_64x64.png"));
        klog.info("Startup  GSEA Version " + buildProps.getProperty("build.version") + " " + buildProps.getProperty("build.timestamp"));
        klog.info("Java " + System.getProperty("java.version") + " (build " + System.getProperty("java.vm.version") + ") " + System.getProperty("java.version.date", ""));
        klog.info("Java Vendor: " + System.getProperty("java.vendor") + " " + System.getProperty("java.vendor.url", ""));
        klog.info("JVM: " + System.getProperty("java.vm.name", "") + " " + System.getProperty("java.vendor.version", "") + "   " + System.getProperty("java.compiler", ""));
        klog.info("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        klog.info("GSEA Directory: " + XPreferencesFactory.kAppRuntimeHomeDir.getAbsolutePath());
        if (SystemUtils.IS_OS_MAC_OSX) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
    }
}

