/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.io.LoopedStreams;
import edu.mit.broad.xbench.core.api.Application;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.text.Document;
import xapps.api.frameworks.fiji.StatusBarAppender;

public class SystemConsole
extends JTextArea {
    public SystemConsole() {
        this.setText("< Process output will appear below >\n\n");
        try {
            LoopedStreams ls = new LoopedStreams();
            PrintStream ps = new PrintStream(ls.getOutputStream());
            System.setOut(ps);
            System.setErr(ps);
            this.startConsoleReaderThread(ls.getInputStream());
            this.setAutoscrolls(true);
        }
        catch (Throwable t) {
            this.setText("Could not open system console properly. Error: " + TraceUtils.getAsString(t));
        }
    }

    public static StatusBarAppender createStatusBarAppender(String name) {
        StatusBarAppender statusBar = new StatusBarAppender(name);
        return statusBar;
    }

    private void startConsoleReaderThread(InputStream inStream) {
        final BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        new Thread(new Runnable(){

            @Override
            public void run() {
                char[] buff = new char[256];
                try {
                    int count;
                    Document doc = SystemConsole.this.getDocument();
                    while (-1 != (count = reader.read(buff, 0, buff.length))) {
                        SystemConsole.this.append(String.valueOf(buff, 0, count));
                        SystemConsole.this.setCaretPosition(doc.getLength());
                    }
                }
                catch (IOException e) {
                    Application.getWindowManager().showMessage(null, "Error reading from BufferedReader: " + String.valueOf(e));
                }
            }
        }).start();
    }
}

