/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.calculation.PlusMatrix;
import org.ujmp.core.calculation.PlusMatrixCalculation;
import org.ujmp.core.doublematrix.DenseDoubleMatrix2D;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlusMatrixDenseMatrix2D
implements PlusMatrixCalculation<DenseMatrix2D, DenseMatrix2D, DenseMatrix2D> {
    PlusMatrixDenseMatrix2D() {
    }

    @Override
    public final void calc(DenseMatrix2D source1, DenseMatrix2D source2, DenseMatrix2D target) {
        if (source1 instanceof DenseDoubleMatrix2D && source2 instanceof DenseDoubleMatrix2D && target instanceof DenseDoubleMatrix2D) {
            PlusMatrix.DENSEDOUBLEMATRIX2D.calc((DenseDoubleMatrix2D)source1, (DenseDoubleMatrix2D)source2, (DenseDoubleMatrix2D)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize(source1, source2, target);
            int r = (int)source1.getRowCount();
            while (--r != -1) {
                int c = (int)source1.getColumnCount();
                while (--c != -1) {
                    BigDecimal v1 = source1.getAsBigDecimal(r, c);
                    BigDecimal v2 = source2.getAsBigDecimal(r, c);
                    BigDecimal result = MathUtil.plus(v1, v2);
                    target.setAsBigDecimal(result, r, c);
                }
            }
            if (source1 != target && (a = source1.getMetaData()) != null) {
                target.setMetaData(a.clone());
            }
        }
    }
}

