/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.objects.MSigDBSpecies;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.core.ObjectBindery;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.genepattern.uiutil.FTPFile;
import org.genepattern.uiutil.FTPList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaWebResources;
import xtools.api.param.ChooserHelper;
import xtools.api.param.Validator;

public class WChipChooserWindow {
    private static final Logger klog = LoggerFactory.getLogger(WChipChooserWindow.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] showDirectlyWithModels() {
        JTabbedPane tabbedPane = new JTabbedPane();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)tabbedPane, "Center");
        Action helpAction = JarResources.createDataFormatAction("#chip");
        BrowserAction infoAction = new BrowserAction("MSigDB Chips", "MSigDB Chips Info", GuiHelper.ICON_HELP16, GseaWebResources.getGseaChipInfoHelpURL());
        DialogDescriptor desc = Application.getWindowManager().createDialogDescriptor("Select a chip", wrapper, helpAction, infoAction, false);
        JList<FTPFile> humanFTPFileJList = new JList<FTPFile>();
        JList<FTPFile> mouseFTPFileJList = new JList<FTPFile>();
        if (XPreferencesFactory.kOnlineMode.getBoolean()) {
            FTPList ftpList = null;
            try {
                ftpList = new FTPList(GseaWebResources.getGseaFTPServer(), GseaWebResources.getGseaFTPServerUserName(), GseaWebResources.getGseaFTPServerPassword());
                try {
                    FTPFile[] humanFTPFiles = ChooserHelper.retrieveFTPFiles(ftpList, ".chip", MSigDBSpecies.Human, GseaWebResources.getGseaFTPServerChipDir(MSigDBSpecies.Human));
                    FTPFile[] mouseFTPFiles = ChooserHelper.retrieveFTPFiles(ftpList, ".chip", MSigDBSpecies.Mouse, GseaWebResources.getGseaFTPServerChipDir(MSigDBSpecies.Mouse));
                    ChooserHelper.populateFTPModel(humanFTPFiles, humanFTPFileJList, desc, new ComparatorFactory.FTPFileByVersionComparator(), 0);
                    ChooserHelper.populateFTPModel(mouseFTPFiles, mouseFTPFileJList, desc, new ComparatorFactory.FTPFileByVersionComparator("Mouse"), 0);
                    tabbedPane.addTab("Human Collection Chips (MSigDB)", new JScrollPane(humanFTPFileJList));
                    tabbedPane.addTab("Mouse Collection Chips (MSigDB)", new JScrollPane(mouseFTPFileJList));
                }
                finally {
                    if (ftpList != null) {
                        ftpList.quit();
                    }
                }
            }
            catch (Exception ex) {
                klog.error(ex.getMessage(), (Throwable)ex);
                tabbedPane.addTab("Human Collection Chips (MSigDB)", new JScrollPane(ChooserHelper.createErrorMessageDisplay(ex)));
                tabbedPane.addTab("Mouse Collection Chips (MSigDB)", new JScrollPane(ChooserHelper.createErrorMessageDisplay(ex)));
            }
        } else {
            tabbedPane.addTab("Human Collection Chips (MSigDB)", new JScrollPane(ChooserHelper.createOfflineMessageDisplay()));
            tabbedPane.addTab("Mouse Collection Chips (MSigDB)", new JScrollPane(ChooserHelper.createOfflineMessageDisplay()));
        }
        JList localChipJList = new JList(ObjectBindery.getModel(Chip.class));
        localChipJList.setSelectionMode(0);
        tabbedPane.addTab("Local Chips", new JScrollPane(localChipJList));
        desc.enableDoubleClickableJList(localChipJList);
        BooleanSupplier errorChecker = () -> {
            boolean haveHuman = !humanFTPFileJList.isSelectionEmpty();
            boolean noMouse = mouseFTPFileJList.isSelectionEmpty();
            if (haveHuman) {
                return noMouse && localChipJList.isSelectionEmpty();
            }
            if (!noMouse) {
                return localChipJList.isSelectionEmpty();
            }
            return true;
        };
        Supplier<Errors> errorMsgBuilder = () -> {
            Errors errors = new Errors("Multiple CHIPs selected");
            errors.add("Multiple CHIP selections are not allowed.\n");
            errors.add("Is there a selection on another tab?");
            errors.add(ChooserHelper.DESELECT_INSTRUCTIONS);
            return errors;
        };
        Validator errorValidator = new Validator(errorChecker, errorMsgBuilder);
        desc.setErrorValidator(errorValidator);
        desc.setDisplayWider();
        int res = desc.show();
        if (res == 2) {
            return null;
        }
        FTPFile selected = humanFTPFileJList.getSelectedValue();
        if (selected != null) {
            return new String[]{selected.getPath()};
        }
        selected = mouseFTPFileJList.getSelectedValue();
        if (selected != null) {
            return new String[]{selected.getPath()};
        }
        Object selectedObj = localChipJList.getSelectedValue();
        if (selectedObj != null) {
            return new String[]{ParserFactory.getCache().getSourcePath(selectedObj)};
        }
        return new String[0];
    }
}

