/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GComboBoxField;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComboBox;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;

abstract class PobParam
extends AbstractParam
implements ActionListener {
    private GComboBoxField cbOptions;

    protected PobParam(String name, String nameEnglish, Class type, String desc, Object def_andonly_hint, boolean reqd) {
        super(name, nameEnglish, type, desc, def_andonly_hint, reqd);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            super.setValue(value);
        } else if (value instanceof String) {
            this.setValue((String)value);
        } else if (value instanceof File) {
            this.setValue((File)value);
        } else if (DataFormat.isCompatibleRepresentationClass(value, this.getTypes())) {
            super.setValue(value);
        } else {
            throw new IllegalArgumentException("Invalid type! Only " + String.valueOf(this.getTypes()) + " File and String (path) accepted. Specified: " + String.valueOf(value) + " class: " + String.valueOf(value.getClass()));
        }
    }

    public void setValue(String filepath) {
        super.setValue(new File(filepath));
    }

    public void setValue(File file) {
        super.setValue(file);
    }

    protected PersistentObject getPob() throws Exception {
        Object val = this.getValue();
        if (val instanceof Object[] && ((Object[])val).length == 1) {
            val = ((Object[])val)[0];
        }
        if (val == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        if (val instanceof PersistentObject) {
            return (PersistentObject)val;
        }
        if (val instanceof File) {
            return ParserFactory.read((File)val);
        }
        throw new RuntimeException("Unexpected value >" + String.valueOf(val) + "< of class: " + String.valueOf(val.getClass()) + " for param: " + this.getName());
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.cbOptions == null) {
            this.cbOptions = ParamHelper.createActionListenerBoundPobComboBox(this, this.getTypes());
            ParamHelper.safeSelectPobValueDefaultOrFirst(this.cbOptions.getComboBox(), this);
        }
        return this.cbOptions;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.setValue(((JComboBox)this.cbOptions.getComponent()).getSelectedItem());
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        try {
            if (this.getValue() == null) {
                return null;
            }
            File file = ParserFactory.getCache().getSourceFile(this.getPob());
            if (full) {
                return file.getAbsolutePath();
            }
            return file.getName();
        }
        catch (Exception e) {
            this.log.warn("Unexpected error", (Throwable)e);
            return null;
        }
    }
}

