/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.MSigDBVersion;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.Versioned;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.vdb.chip.Chip;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;
import xtools.api.ui.GeneSetMatrixChooserUI;

public class GeneSetMatrixMultiChooserParam
extends AbstractParam {
    private MyPobActionListener fAl;
    private GeneSetMatrixChooserUI fChooser;
    private String delimiter = ",";
    private static final String GSEA_ALTERED_FTP_PATH = "ftp.broadinstitute.org:/pub/gsea/msigdb";
    private static final String GSEA_BASE_FTP_PATH = "ftp.broadinstitute.org://pub/gsea/msigdb";

    public GeneSetMatrixMultiChooserParam(boolean reqd) {
        this("gmx", "Gene sets database", "Gene sets database (gmx or gmt files - one or more are allowed)", reqd);
    }

    public GeneSetMatrixMultiChooserParam(String name, String nameEnglish, String desc, boolean reqd) {
        super(name, nameEnglish, GeneSetMatrix[].class, desc, (Object)new GeneSetMatrix[0], (Object[])new GeneSetMatrix[0], reqd);
    }

    public GeneSetMatrix getGeneSetMatrixCombo() throws Exception {
        return this._getGeneSets().toGm();
    }

    public void setAlternateDelimiter(String alternateDelimiter) {
        if (StringUtils.length((CharSequence)alternateDelimiter) > 1) {
            throw new IllegalArgumentException("Illegal alternate delimiter '" + alternateDelimiter + "'; must be a single character only.");
        }
        this.delimiter = alternateDelimiter;
    }

    private Object[] _getObjects() throws Exception {
        Object[] objs;
        Object val = this.getValue();
        if (val instanceof String) {
            String[] paths = this._parse(val.toString());
            objs = new Object[paths.length];
            for (int p = 0; p < paths.length; ++p) {
                String path = paths[p];
                if (path.toLowerCase().startsWith("ftp.") || path.toLowerCase().startsWith("gseaftp.")) {
                    if (AuxUtils.isAux(path)) {
                        if (StringUtils.containsIgnoreCase((CharSequence)path, (CharSequence)"ftp.broadinstitute.org")) {
                            if (SystemUtils.IS_OS_WINDOWS) {
                                path = StringUtils.replace((String)path, (String)"\\", (String)"/");
                            }
                            path = StringUtils.replace((String)path, (String)GSEA_ALTERED_FTP_PATH, (String)GSEA_BASE_FTP_PATH);
                        }
                        GeneSetMatrix gm = ParserFactory.readGeneSetMatrix(path, true);
                        GeneSet geneSet = gm.getGeneSet(AuxUtils.getAuxNameOnlyIncludingHash(path));
                        objs[p] = geneSet;
                        continue;
                    }
                    objs[p] = ParserFactory.readGeneSetMatrix(path, true);
                    continue;
                }
                objs[p] = AuxUtils.isAux(path) ? ParserFactory.readGeneSet(new File(path), true) : ParserFactory.read(new File(path));
            }
        } else {
            objs = val instanceof Object[] ? (Object[])val : new Object[]{val};
        }
        for (Object object : objs) {
            MSigDBVersion version;
            if (!(object instanceof Versioned) || !(version = ((Versioned)object).getMSigDBVersion()).isUnknownVersion()) continue;
            String versionString = version.getVersionString();
            int cutPoint = versionString.lastIndexOf("-unknown-");
            if (cutPoint > 0) {
                versionString = versionString.substring(0, cutPoint);
            }
            this.log.info("Using file '{}' with unknown version", (Object)versionString);
        }
        return objs;
    }

    private String _getName(Object[] objs) {
        String name = "combo";
        if (objs.length == 1 && objs[0] instanceof GeneSetMatrix) {
            name = ((GeneSetMatrix)objs[0]).getName();
        }
        return name;
    }

    private GeneSetsStruc _getGeneSets() throws Exception {
        Object[] objs = this._getObjects();
        if (this.isReqd() && objs.length == 0) {
            throw new IllegalArgumentException("Must specify GeneSetMatrix parameter: " + this.getNameEnglish() + " (" + this.getDesc() + ")");
        }
        ArrayList<GeneSet> gsets = new ArrayList<GeneSet>();
        String name = this._getName(objs);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] instanceof GeneSetMatrix) {
                gsets.addAll(((GeneSetMatrix)objs[i]).getGeneSetsL());
                continue;
            }
            if (objs[i] instanceof GeneSet) {
                gsets.add((GeneSet)objs[i]);
                continue;
            }
            if (objs[i] instanceof Dataset) {
                gsets.add(((Dataset)objs[i]).getRowNamesGeneSet());
                continue;
            }
            if (objs[i] instanceof Chip) {
                gsets.add(((Chip)objs[i]).getProbeNamesAsGeneSet());
                continue;
            }
            throw new IllegalArgumentException("Unknown object: " + String.valueOf(objs[i]));
        }
        return new GeneSetsStruc(name, gsets.toArray(new GeneSet[gsets.size()]));
    }

    private String[] _parse(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Parameter s cannot be null");
        }
        Set<String> vals = ParseUtils.string2stringsSet(s, this.delimiter);
        System.out.println("to parse>" + s + "< got: " + String.valueOf(vals));
        HashSet<String> use = new HashSet<String>();
        Iterator<String> it = vals.iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            if (key.length() <= 0) continue;
            use.add(key);
        }
        return use.toArray(new String[use.size()]);
    }

    private String format(Object[] vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null) continue;
            this.log.debug("{}", vals[i].getClass());
            if (vals[i] instanceof PersistentObject) {
                buf.append(ParserFactory.getCache().getSourcePath(vals[i]));
            } else {
                buf.append(vals[i].toString().trim());
            }
            if (i == vals.length - 1) continue;
            buf.append(this.delimiter);
        }
        return buf.toString();
    }

    private ActionListener getActionListener() {
        if (this.fAl == null) {
            this.fAl = new MyPobActionListener(this);
        }
        return this.fAl;
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean full) {
        Object val = this.getValue();
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof Object[]) {
            Object[] objs = (Object[])val;
            return this.format(objs);
        }
        return this.format(new Object[]{val});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new GeneSetMatrixChooserUI();
            this.fChooser.setCustomActionListener(this.getActionListener());
            String text = this.getValueStringRepresentation(false);
            if (text == null) {
                text = this.format((Object[])this.getDefault());
            }
            this.fChooser.setText(text);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    class GeneSetsStruc {
        GeneSet[] gsets;
        String name;
        MSigDBVersion assumedVersion;

        GeneSetsStruc(String name, GeneSet[] gsets) {
            this.gsets = gsets;
            this.name = name;
            this.assumedVersion = gsets != null && gsets.length > 0 && gsets[0].getMSigDBVersion() != null ? gsets[0].getMSigDBVersion() : MSigDBVersion.createUnknownTrackingVersion(name);
        }

        GeneSetMatrix toGm() {
            return new DefaultGeneSetMatrix(this.name, this.gsets, this.assumedVersion, true);
        }
    }

    private static class MyPobActionListener
    implements ActionListener {
        GeneSetMatrixMultiChooserParam ownerParam;

        public MyPobActionListener(GeneSetMatrixMultiChooserParam ownerParam) {
            this.ownerParam = ownerParam;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.ownerParam.fChooser == null) {
                return;
            }
            CharSequence[] selectedPaths = this.ownerParam.fChooser.getJListWindow().showDirectlyWithModels();
            if (selectedPaths != null && selectedPaths.length > 0) {
                this.ownerParam.fChooser.setText(String.join((CharSequence)this.ownerParam.delimiter, selectedPaths));
            }
        }
    }
}

