/*
 * Decompiled with CFR 0.152.
 */
package xapps.api.frameworks.fiji;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.viewers.SystemConsoleViewer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.genepattern.uiutil.CenteredDialog;

public class StatusBarAppender {
    private JPanel fStatusBar = new JPanel(new BorderLayout());
    private JLabel fStatusBarLabel;
    private SystemConsoleViewer fSystemConsoleComp = new SystemConsoleViewer();
    private JDialog popup;

    public StatusBarAppender(String name) {
        this.fSystemConsoleComp.setBorder(BorderFactory.createTitledBorder("Application messages"));
        this.fStatusBarLabel = new JLabel();
        this.fStatusBarLabel.setIcon(JarResources.getIcon("expandall.png"));
        this.fStatusBarLabel.setToolTipText("Click for application messages (such as # of permutations complete)");
        LabelStatusBarLoggingHandler handler = new LabelStatusBarLoggingHandler(this.fStatusBarLabel);
        LogManager.getLogManager().getLogger("").addHandler(handler);
        this.fStatusBar.add((Component)this.fStatusBarLabel, "West");
        this.fStatusBarLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                StatusBarAppender.this.showPopup();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                StatusBarAppender.this.fStatusBarLabel.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                StatusBarAppender.this.fStatusBarLabel.setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    public JComponent getAsComponent(JFrame frame) {
        this.popup = new CenteredDialog(frame);
        return this.fStatusBar;
    }

    private void showPopup() {
        if (this.popup == null) {
            return;
        }
        this.popup.getContentPane().setLayout(new BorderLayout());
        this.popup.setSize(new Dimension(700, 350));
        this.fSystemConsoleComp.setPreferredSize(new Dimension(700, 350));
        this.popup.getContentPane().add(this.fSystemConsoleComp);
        this.popup.setResizable(true);
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.popup.setVisible(true);
        }
    }

    private class LabelStatusBarLoggingHandler
    extends Handler {
        final JLabel statusBarLabel;

        public LabelStatusBarLoggingHandler(JLabel statusBarLabel) {
            this.statusBarLabel = statusBarLabel;
            this.setLevel(Conf.isDebugMode() ? Level.FINE : Level.INFO);
            this.setFormatter(new SimpleFormatter());
        }

        @Override
        public void close() throws SecurityException {
        }

        @Override
        public void flush() {
        }

        @Override
        public void publish(LogRecord record) {
            if (!this.isLoggable(record)) {
                return;
            }
            try {
                String message = this.getFormatter().format(record);
                Level level = record.getLevel();
                StatusBarAppender.this.fStatusBarLabel.setForeground(Color.BLACK);
                if (level == Level.WARNING) {
                    StatusBarAppender.this.fStatusBarLabel.setForeground(Color.MAGENTA);
                }
                this.statusBarLabel.setText(message);
            }
            catch (Exception ex) {
                this.reportError(null, ex, 5);
            }
        }

        @Override
        public boolean isLoggable(LogRecord record) {
            return this.statusBarLabel != null && super.isLoggable(record);
        }
    }
}

