/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu.jfree;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.genepattern.menu.PlotAction;
import org.genepattern.menu.ViewMenu;
import org.genepattern.menu.jfree.JFreeResetPlotAction;
import org.genepattern.uiutil.CenteredDialog;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.editor.ChartEditor;
import org.jfree.chart.editor.ChartEditorManager;

public class JFreeViewMenu
extends ViewMenu {
    @Override
    protected PlotAction[] createPlotActions() {
        return new PlotAction[]{new JFreeResetPlotAction("Reset"), new ZoomInAction(), new ZoomOutAction(), new PlotOptionsAction()};
    }

    public JFreeViewMenu(JComponent plot, Frame parent) {
        super(plot, parent);
    }

    public static void zoomIn(ChartPanel chartPanel) {
        JFreeChart chart = chartPanel.getChart();
        ValueAxis xAxis = chart.getXYPlot().getDomainAxis();
        ValueAxis yAxis = chart.getXYPlot().getRangeAxis();
        double xmin = xAxis.getLowerBound();
        double xmax = xAxis.getUpperBound();
        double ymin = yAxis.getLowerBound();
        double ymax = yAxis.getUpperBound();
        double deltax = Math.abs(xmax - xmin);
        double deltay = Math.abs(ymax - ymin);
        xAxis.setRange(xmin + deltax * 0.1, xmax - deltax * 0.1);
        yAxis.setRange(ymin + deltay * 0.1, ymax - deltay * 0.1);
    }

    public static void zoomOut(ChartPanel chartPanel) {
        JFreeChart chart = chartPanel.getChart();
        ValueAxis xAxis = chart.getXYPlot().getDomainAxis();
        ValueAxis yAxis = chart.getXYPlot().getRangeAxis();
        double xmin = xAxis.getLowerBound();
        double xmax = xAxis.getUpperBound();
        double ymin = yAxis.getLowerBound();
        double ymax = yAxis.getUpperBound();
        double deltax = Math.abs(xmax - xmin);
        double deltay = Math.abs(ymax - ymin);
        xAxis.setRange(xmin - deltax * 0.1, xmax + deltax * 0.1);
        yAxis.setRange(ymin - deltay * 0.1, ymax + deltay * 0.1);
    }

    public static JDialog showPlotOptionsDialog(final ChartPanel chartPanel, Frame parent) {
        JFreeChart chart = chartPanel.getChart();
        final ChartEditor panel = ChartEditorManager.getChartEditor((JFreeChart)chart);
        final CenteredDialog dialog = new CenteredDialog(parent);
        dialog.setTitle("Display Options");
        JButton cancelButton = new JButton("Cancel");
        final JButton okButton = new JButton("OK");
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == okButton) {
                    panel.updateChart(chartPanel.getChart());
                }
                dialog.dispose();
            }
        };
        cancelButton.addActionListener(l);
        okButton.addActionListener(l);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(cancelButton);
        buttonPanel.add(okButton);
        dialog.getContentPane().add((Component)panel);
        dialog.getContentPane().add((Component)buttonPanel, "South");
        dialog.pack();
        ((Dialog)dialog).setVisible(true);
        return dialog;
    }

    static class ZoomInAction
    extends PlotAction {
        public ZoomInAction() {
            super("Zoom In");
            if (System.getProperty("org.genepattern.menu.showAccelerators", "true").equalsIgnoreCase("true")) {
                KeyStroke ks = KeyStroke.getKeyStroke(93, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
                this.putValue("AcceleratorKey", ks);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChartPanel chartPanel = (ChartPanel)this.getPlot();
            JFreeViewMenu.zoomIn(chartPanel);
        }
    }

    static class ZoomOutAction
    extends PlotAction {
        public ZoomOutAction() {
            super("Zoom Out");
            if (System.getProperty("org.genepattern.menu.showAccelerators", "true").equalsIgnoreCase("true")) {
                KeyStroke ks = KeyStroke.getKeyStroke(91, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
                this.putValue("AcceleratorKey", ks);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ChartPanel chartPanel = (ChartPanel)this.getPlot();
            JFreeViewMenu.zoomOut(chartPanel);
        }
    }

    class PlotOptionsAction
    extends PlotAction {
        JDialog dialog;

        public PlotOptionsAction() {
            super("Display Options...");
        }

        private void createDialog() {
            ChartPanel chartPanel = (ChartPanel)this.getPlot();
            this.dialog = JFreeViewMenu.showPlotOptionsDialog(chartPanel, JFreeViewMenu.this.getFrame());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dialog != null && this.dialog.isShowing()) {
                this.dialog.toFront();
            } else {
                this.createDialog();
            }
        }
    }
}

