/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu.jfree;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.KeyStroke;
import org.genepattern.menu.PlotAction;
import org.genepattern.uiutil.UIUtil;
import org.jfree.chart.ChartPanel;

public class JFreePrintAction
extends PlotAction {
    public JFreePrintAction() {
        super("Print...");
        if (System.getProperty("org.genepattern.menu.showAccelerators", "true").equalsIgnoreCase("true")) {
            KeyStroke ks = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
            this.putValue("AcceleratorKey", ks);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        ChartPanel plot = (ChartPanel)this.getPlot();
        printerJob.setPrintable((Printable)plot);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException pe) {
                UIUtil.showErrorDialog(plot.getTopLevelAncestor(), "A printing error occurred.");
            }
        }
    }
}

