/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.EnrichmentReports;
import edu.mit.broad.genome.swing.ClosableTabComponent;
import edu.mit.broad.genome.utils.ZipUtility;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.tui.TaskManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.genepattern.gsea.LeadingEdgeAnalysis;
import org.genepattern.gsea.ViewAndSearchComponent;
import org.genepattern.gsea.XToolsMessageHandler;
import org.genepattern.uiutil.UIUtil;
import org.jfree.ui.SortableTableModel;
import xtools.api.XToolsApplication;
import xtools.api.param.ToolParamSet;
import xtools.gsea.LeadingEdgeTool;

public class LeadingEdgeWidget
implements Widget {
    private static final Icon ICON = JarResources.getIcon("Lev16_b.gif");
    private EnrichmentDb edb;
    private JTabbedPane tabbedPane;
    private static int runs = 0;
    private ViewAndSearchComponent viewAndSearchComponent;
    private JLabel positiveLabel;
    private JLabel negativeLabel;
    private JPanel phenotypePanel;
    private boolean runningInGenePattern;
    private JFileChooser htmlReportDirChooser;
    private static final int GENE_SET_INDEX = 0;

    public LeadingEdgeWidget(EnrichmentDb edb) {
        if (edb == null) {
            throw new IllegalArgumentException("Param edb cannot be null");
        }
        this.runningInGenePattern = true;
        this.tabbedPane = new JTabbedPane();
        this.edb = edb;
        this.init(edb);
        this.tabbedPane.addTab(null, this.viewAndSearchComponent);
        this.tabbedPane.setTabComponentAt(this.tabbedPane.getTabCount() - 1, new ClosableTabComponent(this.tabbedPane, "GSEA Results", null));
    }

    public LeadingEdgeWidget(JTabbedPane tabbedPane, EnrichmentDb edb) {
        if (edb == null) {
            throw new IllegalArgumentException("Param edb cannot be null");
        }
        this.runningInGenePattern = false;
        this.tabbedPane = tabbedPane;
        UIUtil.setMessageHandler(new XToolsMessageHandler());
        this.edb = edb;
        this.init(edb);
        tabbedPane.addTab(null, this.viewAndSearchComponent);
        tabbedPane.setTabComponentAt(tabbedPane.getTabCount() - 1, new ClosableTabComponent(tabbedPane, "GSEA Results", null));
    }

    @Override
    public JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    @Override
    public JComponent getWrappedComponent() {
        return this.tabbedPane;
    }

    public JComponent getViewAndSearchComponent() {
        return this.viewAndSearchComponent;
    }

    @Override
    public String getAssociatedTitle() {
        return null;
    }

    @Override
    public Icon getAssociatedIcon() {
        return ICON;
    }

    private void init(EnrichmentDb edb) {
        this.positiveLabel = new JLabel(" ");
        this.positiveLabel.setForeground(Color.RED);
        String tcp = "na pos";
        String tcn = "na neg";
        if (edb.getTemplate() != null) {
            tcn = edb.getTemplate().getClassName(0);
            tcn = edb.getTemplate().getClassName(1);
        }
        this.positiveLabel.setText("positive phenotype: " + tcp + "   ");
        this.negativeLabel = new JLabel(" ");
        this.negativeLabel.setForeground(Color.BLUE);
        this.negativeLabel.setText("negative phenotype: " + tcn);
        this.phenotypePanel = new JPanel();
        this.phenotypePanel.add(this.positiveLabel);
        this.phenotypePanel.add(this.negativeLabel);
        ActionListener runListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeadingEdgeWidget.this.runAnalysis();
            }
        };
        ActionListener reportListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LeadingEdgeWidget.this.buildHtmlReport();
            }
        };
        this.viewAndSearchComponent = new ViewAndSearchComponent("Run leading edge analysis", this.createTableModel(), runListener, reportListener);
    }

    private void buildHtmlReport() {
        File outputDir = this.edb.getEdbDir();
        if (this.runningInGenePattern) {
            if (this.htmlReportDirChooser == null) {
                this.htmlReportDirChooser = new JFileChooser();
                this.htmlReportDirChooser.setDialogTitle("Choose output directory");
                this.htmlReportDirChooser.setFileSelectionMode(1);
                this.htmlReportDirChooser.setMultiSelectionEnabled(false);
            }
            if (this.htmlReportDirChooser.showOpenDialog(this.tabbedPane.getTopLevelAncestor()) != 0) {
                return;
            }
            outputDir = this.htmlReportDirChooser.getSelectedFile();
        }
        final File _outputDir = outputDir;
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SwingWorker<Object, Void> worker = new SwingWorker<Object, Void>(){

                @Override
                protected Object doInBackground() throws Exception {
                    LeadingEdgeTool tool = new LeadingEdgeTool();
                    ToolParamSet paramSet = (ToolParamSet)tool.getParamSet();
                    if (LeadingEdgeWidget.this.runningInGenePattern) {
                        paramSet.getAnalysisDirParam().setValue(_outputDir);
                    }
                    paramSet.getParam("altDelim").setValue(";");
                    String gsets = StringUtils.join((Object[])LeadingEdgeWidget.this.viewAndSearchComponent.getSelectedColumnArray(0), (String)";");
                    paramSet.getParam("gsets").setValue(gsets);
                    paramSet.getParam("dir").setValue(LeadingEdgeWidget.this.edb.getEdbDir());
                    if (!LeadingEdgeWidget.this.runningInGenePattern) {
                        TaskManager.getInstance().run(tool, paramSet, 1);
                    } else {
                        tool.execute();
                    }
                    return null;
                }
            };
            worker.execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
            UIUtil.showErrorDialog(this.tabbedPane.getTopLevelAncestor(), "An error occurred while building the HTML report");
        }
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
    }

    private SortableTableModel createTableModel() {
        return new MyTableModel(LeadingEdgeAnalysis.getAllResultsFromEdb(this.edb));
    }

    private void runAnalysis() {
        this.tabbedPane.setCursor(Cursor.getPredefinedCursor(3));
        try {
            SwingWorker<LeadingEdgeAnalysis, Void> worker = new SwingWorker<LeadingEdgeAnalysis, Void>(){

                @Override
                protected LeadingEdgeAnalysis doInBackground() throws Exception {
                    ++runs;
                    try {
                        return LeadingEdgeAnalysis.runAnalysis(LeadingEdgeWidget.this.edb, LeadingEdgeWidget.this.viewAndSearchComponent.getSelectedColumnArray(0), LeadingEdgeWidget.this.tabbedPane);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        LeadingEdgeWidget.this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
                        UIUtil.showErrorDialog(LeadingEdgeWidget.this.tabbedPane.getTopLevelAncestor(), "An error occurred while running leading edge analysis");
                        return null;
                    }
                }

                @Override
                protected void done() {
                    try {
                        LeadingEdgeAnalysis analysis = (LeadingEdgeAnalysis)this.get();
                        if (analysis == null) {
                            return;
                        }
                        String tabTitle = "Leading Edge Analysis-" + runs;
                        LeadingEdgeWidget.this.tabbedPane.addTab(null, analysis.getComponent());
                        LeadingEdgeWidget.this.tabbedPane.setTabComponentAt(LeadingEdgeWidget.this.tabbedPane.getTabCount() - 1, new ClosableTabComponent(LeadingEdgeWidget.this.tabbedPane, tabTitle, null));
                        LeadingEdgeWidget.this.tabbedPane.setSelectedComponent(analysis.getComponent());
                        LeadingEdgeWidget.this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        LeadingEdgeWidget.this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
                        UIUtil.showErrorDialog(LeadingEdgeWidget.this.tabbedPane.getTopLevelAncestor(), "An error occurred while running leading edge analysis");
                    }
                }
            };
            worker.execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.tabbedPane.setCursor(Cursor.getPredefinedCursor(0));
            UIUtil.showErrorDialog(this.tabbedPane.getTopLevelAncestor(), "An error occurred while running leading edge analysis");
        }
    }

    public static void main(String[] args) {
        if (!SystemUtils.IS_OS_MAC_OSX) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (args.length != 1) {
            UIUtil.showMessageDialog(null, "org.genepattern.gsea.LeadingEdgeWidget.main expecting single command line argument");
            System.exit(0);
        }
        String zipFile = args[0];
        File dir = null;
        try {
            dir = File.createTempFile("gsea", null);
        }
        catch (IOException e) {
            e.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while reading the input zip file");
            System.exit(0);
        }
        dir.delete();
        dir.mkdir();
        final File f = dir;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    FileUtils.deleteDirectory((File)f);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    UIUtil.showMessageDialog(null, "unable to delete directory containing unpacked GSEA zip file");
                }
            }
        });
        ZipUtility zipUtil = new ZipUtility();
        try {
            zipUtil.unzip(new File(zipFile), dir);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while unzipping directory archive");
            System.exit(0);
        }
        String title = "Leading Edge Viewer - " + new File(zipFile).getName();
        Application.registerHandler(new XToolsApplication());
        EnrichmentDb edb = null;
        try {
            edb = ParserFactory.readEdb(dir, true, true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            UIUtil.showMessageDialog(null, "An error occurred while reading the input file");
            System.exit(0);
        }
        JFrame frame = new JFrame();
        frame.setTitle(title);
        frame.setDefaultCloseOperation(3);
        LeadingEdgeWidget widget = new LeadingEdgeWidget(edb);
        frame.getContentPane().add(widget.tabbedPane);
        UIUtil.sizeToScreen(frame);
        frame.setVisible(true);
    }

    static {
        System.setProperty("org.genepattern.menu.showAccelerators", "false");
    }

    private static class MyTableModel
    extends SortableTableModel {
        private String[] columnNames = new String[]{"Gene Set", "Size", "ES", "NES", "NOM p-val", "FDR q-val", "FWER p-val", "Rank at Max", "Leading Edge"};
        private Class[] columnClasses = new Class[]{String.class, Integer.class, Float.class, Float.class, Float.class, Float.class, Float.class, Integer.class, String.class};
        private Comparator<EnrichmentResult> BY_GS_NAME = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return result1.getGeneSetName().compareTo(result2.getGeneSetName());
            }
        };
        private Comparator<EnrichmentResult> BY_GS_MEMBERS = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return result1.getGeneSet().getNumMembers() - result2.getGeneSet().getNumMembers();
            }
        };
        private Comparator<EnrichmentResult> BY_ES = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return Float.compare(result1.getScore().getES(), result2.getScore().getES());
            }
        };
        private Comparator<EnrichmentResult> BY_NES = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return Float.compare(result1.getScore().getNES(), result2.getScore().getNES());
            }
        };
        private Comparator<EnrichmentResult> BY_NP = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return Float.compare(result1.getScore().getNP(), result2.getScore().getNP());
            }
        };
        private Comparator<EnrichmentResult> BY_FDR = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return Float.compare(result1.getScore().getFDR(), result2.getScore().getFDR());
            }
        };
        private Comparator<EnrichmentResult> BY_FWER = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return Float.compare(result1.getScore().getFWER(), result2.getScore().getFWER());
            }
        };
        private Comparator<EnrichmentResult> BY_RANK_AT_MAX = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return result1.getSignal().getRankAtMax() - result2.getSignal().getRankAtMax();
            }
        };
        private Comparator<EnrichmentResult> BY_LEADING_EDGE = new Comparator<EnrichmentResult>(){

            @Override
            public int compare(EnrichmentResult result1, EnrichmentResult result2) {
                if (result1 == null) {
                    return result2 == null ? 0 : -1;
                }
                if (result2 == null) {
                    return 1;
                }
                return EnrichmentReports.getLeadingEdge(result1).compareTo(EnrichmentReports.getLeadingEdge(result2));
            }
        };
        private EnrichmentResult[] enrichmentResults;
        private EnrichmentResult[] sortedResults;

        public MyTableModel(EnrichmentResult[] enrichmentResults) {
            this.enrichmentResults = enrichmentResults;
            this.sortedResults = enrichmentResults;
        }

        public boolean isSortable(int column) {
            return true;
        }

        public void sortByColumn(int column, boolean ascending) {
            super.sortByColumn(column, ascending);
            Arrays.parallelSort(this.sortedResults, this.comparatorByColumn(column, ascending));
        }

        public Comparator<EnrichmentResult> comparatorByColumn(int column, boolean ascending) {
            switch (column) {
                case 0: {
                    return ascending ? this.BY_GS_NAME : this.BY_GS_NAME.reversed();
                }
                case 1: {
                    return ascending ? this.BY_GS_MEMBERS : this.BY_GS_MEMBERS.reversed();
                }
                case 2: {
                    return ascending ? this.BY_ES : this.BY_ES.reversed();
                }
                case 3: {
                    return ascending ? this.BY_NES : this.BY_NES.reversed();
                }
                case 4: {
                    return ascending ? this.BY_NP : this.BY_NP.reversed();
                }
                case 5: {
                    return ascending ? this.BY_FDR : this.BY_FDR.reversed();
                }
                case 6: {
                    return ascending ? this.BY_FWER : this.BY_FWER.reversed();
                }
                case 7: {
                    return ascending ? this.BY_RANK_AT_MAX : this.BY_RANK_AT_MAX.reversed();
                }
                case 8: {
                    return ascending ? this.BY_LEADING_EDGE : this.BY_LEADING_EDGE.reversed();
                }
            }
            return ascending ? this.BY_GS_NAME : this.BY_GS_NAME.reversed();
        }

        public int getRowCount() {
            return this.enrichmentResults.length;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Class getColumnClass(int j) {
            return this.columnClasses[j];
        }

        public String getColumnName(int j) {
            return this.columnNames[j];
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            GeneSet gset = this.sortedResults[rowIndex].getGeneSet();
            EnrichmentScore score = this.sortedResults[rowIndex].getScore();
            switch (columnIndex) {
                case 0: {
                    return gset.getName(true);
                }
                case 1: {
                    return gset.getNumMembers();
                }
                case 2: {
                    return Float.valueOf(score.getES());
                }
                case 3: {
                    return Float.valueOf(score.getNES());
                }
                case 4: {
                    return Float.valueOf(score.getNP());
                }
                case 5: {
                    return Float.valueOf(score.getFDR());
                }
                case 6: {
                    return Float.valueOf(score.getFWER());
                }
                case 7: {
                    return this.sortedResults[rowIndex].getSignal().getRankAtMax();
                }
                case 8: {
                    return EnrichmentReports.getLeadingEdge(this.sortedResults[rowIndex]);
                }
            }
            return null;
        }
    }
}

