/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.alg.ComparatorFactory;
import edu.mit.broad.genome.alg.GeneSetStats;
import edu.mit.broad.genome.alg.gsea.PValueCalculatorImpls;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.objects.BitSetDataset;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GPWrappers;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import gnu.trove.TFloatIntHashMap;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.gsea.GeneHistogram;
import org.genepattern.gsea.GeneSetSimilarityPanel;
import org.genepattern.gsea.HCLAlgorithm;
import org.genepattern.gsea.JaccardHistogram;
import org.genepattern.gsea.LeadingEdgePanel;
import org.genepattern.heatmap.ColorScheme;
import org.genepattern.heatmap.HeatMapComponent;
import org.genepattern.menu.jfree.JFreeMenuBar;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;

public class LeadingEdgeAnalysis {
    private JPanel mainComponent;
    private JaccardHistogram jaccardHistogram = new JaccardHistogram();
    private final GeneHistogram geneHistogram = new GeneHistogram();
    private HeatMapComponent geneSetSimilarityHeatmap;
    private LeadingEdgePanel leadingEdgePanel;
    private Dataset clusteredDataset = null;
    private static final String LEADING_EDGE_MATRIX_KEY = "Leading Edge Matrix";
    private static final String GENE_SET_SIMILARITY_MATRIX_KEY = "Gene Set Similarity Matrix";
    private static final String GENE_HISTOGRAM_KEY = "Gene Histogram";
    private static final String JACCARD_HISTOGRAM_KEY = "Jaccard Histogram of Gene Sets";

    public static final LeadingEdgeAnalysis runAnalysis(EnrichmentDb edb, String[] gsetNames, JTabbedPane tabbedPane) {
        Frame parentFrame = tabbedPane == null ? null : (Frame)tabbedPane.getTopLevelAncestor();
        Dimension containerDim = tabbedPane == null ? null : new Dimension(tabbedPane.getWidth(), tabbedPane.getHeight());
        GeneSet[] gsets = new GeneSet[gsetNames.length];
        for (int r = 0; r < gsetNames.length; ++r) {
            EnrichmentResult result = edb.getResultForGeneSet(gsetNames[r]);
            gsets[r] = result.getSignal().getAsGeneSet();
        }
        DefaultGeneSetMatrix lev_gmx = new DefaultGeneSetMatrix("leading_edge_matrix_for_" + edb.getName(), gsets);
        LeadingEdgeAnalysis analysis = new LeadingEdgeAnalysis(lev_gmx, edb.getRankedList(), parentFrame, containerDim);
        analysis.setResultDirectory(edb.getEdbDir());
        return analysis;
    }

    public static EnrichmentResult[] getAllResultsFromEdb(EnrichmentDb edb_original) {
        String normModeName = "meandiv";
        PValueCalculatorImpls.GseaImpl pvc = new PValueCalculatorImpls.GseaImpl(normModeName);
        EnrichmentResult[] results = pvc.calcNPValuesAndFDR(edb_original.getResults());
        EnrichmentDb edb = edb_original.cloneDeep(results);
        EnrichmentResult[] enrichmentResults = edb.getResults(new ComparatorFactory.EnrichmentResultByNESComparator(Order.DESCENDING));
        return enrichmentResults;
    }

    private Dataset _morph(Dataset ds, RankedList rl) {
        Matrix m = new Matrix(ds.getNumRow(), ds.getNumCol());
        for (int r = 0; r < ds.getNumRow(); ++r) {
            for (int c = 0; c < ds.getNumCol(); ++c) {
                float score = rl.getScore(ds.getColumnName(c));
                float value = ds.getElement(r, c);
                if (value == 1.0f) {
                    m.setElement(r, c, score);
                    continue;
                }
                m.setElement(r, c, value);
            }
        }
        return new DefaultDataset(ds.getName(), m, ds.getRowNames(), ds.getColumnNames(), ds.getAnnot());
    }

    public void setResultDirectory(File file) {
        this.leadingEdgePanel.setResultDirectory(file);
    }

    public LeadingEdgeAnalysis(GeneSetMatrix lev_gmx, RankedList rankedList, Frame parent, Dimension containerDim) {
        int i;
        GeneSet[] gsets = lev_gmx.getGeneSets();
        Dataset lev_ds = new BitSetDataset(lev_gmx).toDataset();
        try {
            this.clusteredDataset = HCLAlgorithm.cluster(lev_ds);
        }
        catch (Throwable t) {
            this.clusteredDataset = lev_ds;
            t.printStackTrace();
        }
        final Dataset lev_ds_clustered_m = rankedList != null ? this._morph(this.clusteredDataset, rankedList) : this.clusteredDataset;
        this.leadingEdgePanel = new LeadingEdgePanel(parent);
        ColorScheme cs = rankedList != null ? GPWrappers.createColorScheme_for_lev_with_score(lev_ds_clustered_m) : new ColorScheme(){

            @Override
            public Color getColor(int row, int column) {
                return lev_ds_clustered_m.getElement(row, column) == 0.0f ? Color.white : Color.yellow;
            }

            @Override
            public void setDataset(IExpressionData d) {
            }

            @Override
            public Component getLegend() {
                return null;
            }
        };
        this.leadingEdgePanel.setData(GPWrappers.createIExpressionData(lev_ds_clustered_m), cs);
        GeneSetStats stats = new GeneSetStats();
        GeneSetStats.RedStruc rs = stats.calcRedundancy(gsets, false);
        GeneSetSimilarityPanel geneSetSimilarityPanel = new GeneSetSimilarityPanel(parent);
        GeneSet[] reorderedGeneSets = new GeneSet[gsets.length];
        HashMap<String, Integer> geneSetName2Index = new HashMap<String, Integer>();
        for (i = 0; i < gsets.length; ++i) {
            geneSetName2Index.put(gsets[i].getName(true), i);
        }
        for (i = 0; i < gsets.length; ++i) {
            String geneSetName = lev_ds_clustered_m.getRowName(i);
            reorderedGeneSets[i] = gsets[(Integer)geneSetName2Index.get(geneSetName)];
        }
        geneSetSimilarityPanel.setGeneSets(reorderedGeneSets);
        TFloatIntHashMap jaccardToOccurrencesMap = rs.jaccardDistrib;
        this.jaccardHistogram.setJaccardToOccurrencesMap(jaccardToOccurrencesMap);
        this.jaccardHistogram.setPreferredSize(new Dimension(100, 100));
        RankedList featureFrequency = rs.featureFreq;
        this.geneHistogram.setFeatureFrequency(featureFrequency, rankedList != null ? rankedList : null);
        ChartMouseListener listener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                int mouseY;
                int mouseX = event.getTrigger().getX();
                int index = LeadingEdgeAnalysis.this.geneHistogram.getXIndex(mouseX, mouseY = event.getTrigger().getY());
                if (index != -1) {
                    String geneName = LeadingEdgeAnalysis.this.geneHistogram.getGeneName(index);
                    int columnIndex = lev_ds_clustered_m.getColumnIndex(geneName);
                    LeadingEdgeAnalysis.this.leadingEdgePanel.getHeatMapComponent().getSampleTable().setColumnSelectionInterval(columnIndex, columnIndex);
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        };
        this.geneHistogram.getChartPanel().addChartMouseListener(listener);
        this.geneHistogram.setPreferredSize(new Dimension(100, 100));
        JScrollPane leadingEdgeSP = new JScrollPane(this.leadingEdgePanel.getHeatMapComponent());
        leadingEdgeSP.setBorder(null);
        this.geneSetSimilarityHeatmap = geneSetSimilarityPanel.getHeatMapComponent();
        JScrollPane geneSetSP = new JScrollPane(this.geneSetSimilarityHeatmap);
        geneSetSP.setBorder(null);
        if (parent == null) {
            return;
        }
        this.mainComponent = new JPanel();
        JSplitPane topBottomSplit = new JSplitPane(0);
        JSplitPane leftRightTopSplit = new JSplitPane(1);
        JSplitPane leftRightBotSplit = new JSplitPane(1);
        topBottomSplit.add(leftRightTopSplit);
        topBottomSplit.add(leftRightBotSplit);
        topBottomSplit.setResizeWeight(0.5);
        leftRightTopSplit.setResizeWeight(0.5);
        leftRightBotSplit.setResizeWeight(0.5);
        this.mainComponent.add(topBottomSplit);
        UIManager.getDefaults().put("JideSplitPane.dividerSize", (Object)9);
        int width = containerDim.width;
        int height = containerDim.height;
        this.mainComponent.setPreferredSize(containerDim);
        JPanel f = new JPanel(new BorderLayout());
        f.setToolTipText(LEADING_EDGE_MATRIX_KEY);
        f.add((Component)this.leadingEdgePanel.getMenuBar(), "First");
        f.add((Component)leadingEdgeSP, "Center");
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        leftRightTopSplit.add(f);
        f.setVisible(true);
        f = new JPanel(new BorderLayout());
        f.setToolTipText(GENE_SET_SIMILARITY_MATRIX_KEY);
        f.add((Component)geneSetSimilarityPanel.getMenuBar(), "First");
        f.add((Component)geneSetSP, "Center");
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        leftRightTopSplit.add(f);
        f.setVisible(true);
        f = new JPanel(new BorderLayout());
        f.setToolTipText(GENE_HISTOGRAM_KEY);
        JFreeMenuBar menuBar = new JFreeMenuBar((JComponent)this.geneHistogram.getChartPanel(), parent);
        f.add((Component)menuBar, "First");
        f.add((Component)new JScrollPane(this.geneHistogram), "Center");
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        leftRightBotSplit.add(f);
        f.setVisible(true);
        f = new JPanel(new BorderLayout());
        f.setToolTipText(JACCARD_HISTOGRAM_KEY);
        menuBar = new JFreeMenuBar((JComponent)this.jaccardHistogram.getChartPanel(), parent);
        f.add((Component)menuBar, "First");
        f.add((Component)new JScrollPane(this.jaccardHistogram), "Center");
        f.setPreferredSize(new Dimension(width / 2, height / 2));
        leftRightBotSplit.add(f);
        f.setVisible(true);
        topBottomSplit.setDividerLocation(0.5);
        leftRightTopSplit.setDividerLocation(0.5);
        leftRightBotSplit.setDividerLocation(0.5);
    }

    public Component getComponent() {
        return this.mainComponent;
    }

    public JaccardHistogram getJaccardHistogram() {
        return this.jaccardHistogram;
    }

    public GeneHistogram getGeneHistogram() {
        return this.geneHistogram;
    }

    public HeatMapComponent getGeneSetSimilarityHeatmap() {
        return this.geneSetSimilarityHeatmap;
    }

    public LeadingEdgePanel getLeadingEdgePanel() {
        return this.leadingEdgePanel;
    }

    public Dataset getClusteredDataset() {
        return this.clusteredDataset;
    }
}

