/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.genepattern.annotation.SparseClassVectorListener;

public class SparseClassVector {
    Map row2AssignmentMap = new HashMap();
    Map classNumber2ColorMap = new HashMap();
    Map classNumber2NameMap = new HashMap();
    Map<List, String> group2GroupName = new HashMap<List, String>();
    List<SparseClassVectorListener> listeners = new ArrayList<SparseClassVectorListener>();
    List<List> groups = new ArrayList<List>();

    public void slice(int[] order) {
        HashMap<Integer, List> temp = new HashMap<Integer, List>();
        for (Integer row : this.row2AssignmentMap.keySet()) {
            List classNumbers = (List)this.row2AssignmentMap.get(row);
            temp.put(order[row], classNumbers);
        }
        this.row2AssignmentMap = temp;
    }

    public void addListener(SparseClassVectorListener l) {
        this.listeners.add(l);
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            SparseClassVectorListener listener = this.listeners.get(i);
            listener.classChanged();
        }
    }

    public List getMembers(Integer classNumber) {
        ArrayList<Integer> members = new ArrayList<Integer>();
        for (Integer row : this.row2AssignmentMap.keySet()) {
            List classNumbers = (List)this.row2AssignmentMap.get(row);
            if (!classNumbers.contains(classNumber)) continue;
            members.add(row);
        }
        return members;
    }

    public void setClass(Integer classNumber, String className, Color c) {
        this.classNumber2NameMap.put(classNumber, className);
        this.classNumber2ColorMap.put(classNumber, c);
        this.notifyListeners();
    }

    public Iterator getClassNumbers() {
        return this.classNumber2NameMap.keySet().iterator();
    }

    public List getClassNumbers(int index) {
        return (List)this.row2AssignmentMap.get(index);
    }

    public Color getColor(Integer i) {
        return (Color)this.classNumber2ColorMap.get(i);
    }

    public String getClassName(Integer i) {
        return (String)this.classNumber2NameMap.get(i);
    }

    public List<List> getClassGroups() {
        return this.groups;
    }

    public String getClassGroupName(List group) {
        return this.group2GroupName.get(group);
    }

    public void addClassGroup(List group, String groupName) {
        List immutableGroup = Collections.unmodifiableList(group);
        this.groups.add(immutableGroup);
        this.group2GroupName.put(immutableGroup, groupName);
    }

    public void removeClassGroup(List group) {
        this.groups.remove(group);
        this.group2GroupName.remove(group);
    }

    public void addClass(int index, Integer classNumber) {
        ArrayList<Integer> assignments = (ArrayList<Integer>)this.row2AssignmentMap.get(index);
        if (assignments == null) {
            assignments = new ArrayList<Integer>();
            this.row2AssignmentMap.put(index, assignments);
        }
        assignments.add(classNumber);
    }

    public void removeClass(int index, Integer classNumber) {
        List assignments = (List)this.row2AssignmentMap.get(index);
        assignments.remove(classNumber);
    }

    public void removeClass(Integer classNumber) {
        for (Integer row : this.row2AssignmentMap.keySet()) {
            this.removeClass(row, classNumber);
        }
        this.classNumber2ColorMap.remove(classNumber);
        this.classNumber2NameMap.remove(classNumber);
        this.notifyListeners();
    }
}

