/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.annotation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.genepattern.annotation.SetAnnotatorModel;
import org.genepattern.annotation.SparseClassVector;
import org.genepattern.uiutil.CenteredDialog;
import org.genepattern.uiutil.UIUtil;

public class SampleClassEditor
extends CenteredDialog {
    private JComboBox classComboBox = new JComboBox();
    private JPanel colorPanel;
    private JButton deleteButton = new JButton("Delete");
    private JList list = new JList();
    private JScrollPane scrollPane = new JScrollPane(this.list);
    private Container featureListContainer;
    private JComboBox groupsComboBox;
    private SparseClassVector classVector;
    private SetAnnotatorModel model;

    public SampleClassEditor(final Frame parent, SetAnnotatorModel model, SparseClassVector cv) {
        super(parent);
        this.model = model;
        this.classVector = cv;
        this.setTitle("Sample Annotations");
        this.classComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyClass selectedClass = (MyClass)SampleClassEditor.this.classComboBox.getSelectedItem();
                if (selectedClass != null) {
                    Color c = SampleClassEditor.this.classVector.getColor(selectedClass.classNumber);
                    SampleClassEditor.this.colorPanel.setBackground(c);
                    SampleClassEditor.this.setMembers(selectedClass.classNumber);
                } else {
                    SampleClassEditor.this.colorPanel.setBackground(Color.BLACK);
                    SampleClassEditor.this.setMembers(-1);
                }
            }
        });
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassGroup group = (ClassGroup)SampleClassEditor.this.groupsComboBox.getSelectedItem();
                if (group == null) {
                    return;
                }
                if (UIUtil.showConfirmDialog(parent, "Are you sure you want to delete " + group.toString() + "?")) {
                    for (int j = 0; j < group.group.size(); ++j) {
                        SampleClassEditor.this.classVector.removeClass((Integer)group.group.get(j));
                    }
                    SampleClassEditor.this.classVector.removeClassGroup(group.group);
                    SampleClassEditor.this.groupsComboBox.removeItem(group);
                    SampleClassEditor.this.classComboBox.removeAllItems();
                    if (SampleClassEditor.this.groupsComboBox.getItemCount() > 0) {
                        SampleClassEditor.this.groupsComboBox.setSelectedIndex(0);
                    }
                }
            }
        });
        this.featureListContainer = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel();
        this.groupsComboBox = new JComboBox();
        List<List> classGroups = this.classVector.getClassGroups();
        if (classGroups == null || classGroups.size() == 0) {
            UIUtil.showMessageDialog(parent, "No sample annotations loaded.\nLoad sample annotations by clicking Open Cls File on the File menu.");
            return;
        }
        for (int i = 0; i < classGroups.size(); ++i) {
            List group = classGroups.get(i);
            ClassGroup classGroup = new ClassGroup(group, this.classVector);
            this.groupsComboBox.addItem(classGroup);
        }
        this.groupsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassGroup classGroup = (ClassGroup)SampleClassEditor.this.groupsComboBox.getSelectedItem();
                SampleClassEditor.this.classComboBox.removeAllItems();
                if (classGroup != null) {
                    for (int i = 0; i < classGroup.group.size(); ++i) {
                        Integer classNumber = (Integer)classGroup.group.get(i);
                        SampleClassEditor.this.classComboBox.addItem(new MyClass(SampleClassEditor.this.classVector.getClassName(classNumber), classNumber));
                    }
                    SampleClassEditor.this.classComboBox.setSelectedIndex(0);
                }
            }
        });
        topPanel.add(this.groupsComboBox);
        topPanel.add(this.deleteButton);
        this.colorPanel = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                int descent = g.getFontMetrics().getDescent();
                g.drawString("Click to edit...", 4, this.getHeight() - descent);
            }
        };
        this.colorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Integer classNumber = ((MyClass)SampleClassEditor.this.classComboBox.getSelectedItem()).classNumber;
                Color c = JColorChooser.showDialog(parent, "Select Color", SampleClassEditor.this.colorPanel.getBackground());
                if (c != null) {
                    SampleClassEditor.this.colorPanel.setBackground(c);
                    SampleClassEditor.this.classVector.setClass(classNumber, SampleClassEditor.this.classVector.getClassName(classNumber), c);
                }
            }
        });
        this.colorPanel.setPreferredSize(new Dimension(100, 20));
        this.colorPanel.setMinimumSize(new Dimension(100, 20));
        this.colorPanel.setBorder(BorderFactory.createEtchedBorder());
        this.groupsComboBox.setSelectedIndex(0);
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(this.classComboBox);
        bottomPanel.add(this.colorPanel);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)topPanel, "North");
        temp.add((Component)bottomPanel, "Center");
        this.featureListContainer.add((Component)temp, "North");
        this.featureListContainer.add((Component)this.scrollPane, "Center");
        this.setContentPane(this.featureListContainer);
        this.pack();
        this.setVisible(true);
    }

    private void setMembers(Integer classNumber) {
        Vector<String> members = new Vector<String>();
        List memberIndices = this.classVector.getMembers(classNumber);
        for (int i = 0; i < memberIndices.size(); ++i) {
            Integer row = (Integer)memberIndices.get(i);
            members.add(this.model.getName(row));
        }
        this.list.setListData(members);
    }

    static class ClassGroup {
        List group;
        String name;
        SparseClassVector classVector;

        public ClassGroup(List group, SparseClassVector classVector) {
            this.group = group;
            this.classVector = classVector;
            this.update();
        }

        public void update() {
            this.name = this.classVector.getClassGroupName(this.group);
        }

        public String toString() {
            return this.name;
        }
    }

    private static class MyClass {
        String className;
        Integer classNumber;

        public MyClass(String className, Integer classNumber) {
            this.className = className;
            this.classNumber = classNumber;
        }

        public String toString() {
            return this.className;
        }
    }
}

