/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.GseaSimpleInternalFrame;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.viewers.ReportViewer;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import edu.mit.broad.xbench.tui.ParamSetDisplay;
import edu.mit.broad.xbench.tui.ReportStub;
import edu.mit.broad.xbench.tui.ToolLauncher;
import edu.mit.broad.xbench.tui.ToolRunnerControl;
import edu.mit.broad.xbench.tui.ToolSelectorTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.Tool;
import xtools.api.ToolCategory;
import xtools.api.param.ParamSet;

public class ToolLauncherDefaultImpl
extends JPanel
implements ToolLauncher,
MouseMotionListener,
ToolRunnerControl.DisplayHook {
    private String fTitle = "Analysis history";
    private Icon fIcon = ReportViewer.ICON;
    private static final Logger klog = LoggerFactory.getLogger(ToolLauncherDefaultImpl.class);
    private final JSplitPane splitPane = new JSplitPane();
    private ToolSelectorTree fToolSelectorTree;
    private final Map fToolParamSetDisplayMap = new WeakHashMap();
    private Tool fCurrTool;
    private ToolRunnerControl fToolRunner;
    private final Map fToolCatDescMap = new WeakHashMap();
    private final Map fReportViewerPanelMap = new WeakHashMap();
    private ToolLauncherDefaultImpl fInstance = this;
    private Report fCurrReport;
    private ReportStub fCurrReportStub;
    private static final int LHS_SIZE = 250;

    public ToolLauncherDefaultImpl() {
        this.splitPane.setOrientation(1);
        this.fToolSelectorTree = new ToolSelectorTree();
        JScrollPane sp = new JScrollPane(this.fToolSelectorTree.getComponent());
        int width = XPreferencesFactory.getToolTreeWidth();
        int width_min = XPreferencesFactory.getToolTreeWidth_min();
        sp.setPreferredSize(new Dimension(width, this.splitPane.getHeight()));
        sp.setMinimumSize(new Dimension(width_min, 0));
        GseaSimpleInternalFrame sif = new GseaSimpleInternalFrame(this.fTitle);
        sif.setPreferredSize(new Dimension(width - 20, this.splitPane.getHeight() - 20));
        sif.setMinimumSize(new Dimension(width_min, 0));
        sif.add(sp);
        this.splitPane.add((Component)((Object)sif), "left");
        this.splitPane.add((Component)GuiHelper.createNaPlaceholder(), "right");
        this.splitPane.setDividerLocation(XPreferencesFactory.getToolTreeDivLocation());
        this.splitPane.setOneTouchExpandable(false);
        this.splitPane.setDividerSize(3);
        this.splitPane.setLastDividerLocation(250);
        this.fToolRunner = new ToolRunnerControl(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane, "Center");
        this.fToolSelectorTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                try {
                    Object val;
                    int divloc = ToolLauncherDefaultImpl.this.splitPane.getDividerLocation();
                    TreePath path = ToolLauncherDefaultImpl.this.fToolSelectorTree.getSelectionPath();
                    if (path == null && ToolLauncherDefaultImpl.this.fCurrReport != null) {
                        val = ToolLauncherDefaultImpl.this.fCurrReport;
                    } else if (path == null && ToolLauncherDefaultImpl.this.fCurrReportStub != null) {
                        val = ToolLauncherDefaultImpl.this.fCurrReportStub;
                    } else {
                        if (path == null) {
                            ToolLauncherDefaultImpl.this.disableLauncher();
                            ToolLauncherDefaultImpl.this.splitPane.setDividerLocation(divloc);
                            return;
                        }
                        val = path.getLastPathComponent();
                    }
                    if (val == null) {
                        ToolLauncherDefaultImpl.this.disableLauncher();
                        return;
                    }
                    if (val instanceof DefaultMutableTreeNode) {
                        ToolLauncherDefaultImpl.this.fCurrReport = null;
                        ToolLauncherDefaultImpl.this.fCurrReportStub = null;
                        if ((val = ((DefaultMutableTreeNode)val).getUserObject()) instanceof Tool) {
                            Tool tool = (Tool)val;
                            if (tool != ToolLauncherDefaultImpl.this.fCurrTool) {
                                Object obj = ToolLauncherDefaultImpl.this.fToolParamSetDisplayMap.get(tool);
                                if (obj == null) {
                                    obj = new ParamSetDisplay(tool.getTitle(), null, tool.getParamSet(), ToolLauncherDefaultImpl.this.fInstance);
                                    ((ParamSetDisplay)obj).addMouseMotionListener(ToolLauncherDefaultImpl.this.fInstance);
                                    ToolLauncherDefaultImpl.this.fToolParamSetDisplayMap.put(tool, obj);
                                }
                                ParamSetDisplay psd = (ParamSetDisplay)obj;
                                JScrollPane pane = new JScrollPane(psd.getAsComponent());
                                ToolLauncherDefaultImpl.this.splitPane.setRightComponent(pane);
                                ToolLauncherDefaultImpl.this.splitPane.revalidate();
                                ToolLauncherDefaultImpl.this.fCurrTool = tool;
                            }
                            ToolLauncherDefaultImpl.this.checkTable();
                        } else if (val instanceof ToolCategory) {
                            ToolLauncherDefaultImpl.this.fCurrTool = null;
                            ToolLauncherDefaultImpl.this.showToolCategoryInfo((ToolCategory)val);
                        } else if (val instanceof Report) {
                            Report rpt;
                            ToolLauncherDefaultImpl.this.fCurrTool = null;
                            ToolLauncherDefaultImpl.this.fCurrReport = rpt = (Report)val;
                            Object obj = ToolLauncherDefaultImpl.this.fReportViewerPanelMap.get(rpt);
                            if (obj == null) {
                                obj = new ReportViewer(rpt);
                                ToolLauncherDefaultImpl.this.fReportViewerPanelMap.put(rpt, obj);
                            }
                            ToolLauncherDefaultImpl.this.fToolRunner.setEnabledControls(false);
                            ToolLauncherDefaultImpl.this.splitPane.setRightComponent((JPanel)obj);
                            ToolLauncherDefaultImpl.this.splitPane.revalidate();
                        } else if (val instanceof ReportStub) {
                            ToolLauncherDefaultImpl.this.fCurrTool = null;
                            ReportStub stub = (ReportStub)val;
                            try {
                                Report rpt = stub.getReport(false);
                                ToolLauncherDefaultImpl.this.fCurrReportStub = stub;
                                Object obj = ToolLauncherDefaultImpl.this.fReportViewerPanelMap.get(rpt);
                                if (obj == null) {
                                    obj = new ReportViewer(rpt);
                                    ToolLauncherDefaultImpl.this.fReportViewerPanelMap.put(rpt, obj);
                                }
                                ToolLauncherDefaultImpl.this.fToolRunner.setEnabledControls(false);
                                ToolLauncherDefaultImpl.this.splitPane.setRightComponent((JPanel)obj);
                                ToolLauncherDefaultImpl.this.splitPane.revalidate();
                            }
                            catch (Throwable t) {
                                Application.getWindowManager().showError("Bad reports file", t);
                                stub.getReportFile().deleteOnExit();
                                ToolLauncherDefaultImpl.this.disableLauncher();
                            }
                        } else {
                            ToolLauncherDefaultImpl.this.disableLauncher();
                        }
                    } else if (val instanceof Report) {
                        Report rpt;
                        ToolLauncherDefaultImpl.this.fCurrTool = null;
                        ToolLauncherDefaultImpl.this.fCurrReport = rpt = (Report)val;
                        Object obj = ToolLauncherDefaultImpl.this.fReportViewerPanelMap.get(rpt);
                        if (obj == null) {
                            obj = new ReportViewer(rpt);
                            ToolLauncherDefaultImpl.this.fReportViewerPanelMap.put(rpt, obj);
                        }
                        ToolLauncherDefaultImpl.this.fToolRunner.setEnabledControls(false);
                        ToolLauncherDefaultImpl.this.splitPane.setRightComponent((JPanel)obj);
                        ToolLauncherDefaultImpl.this.splitPane.revalidate();
                        ToolLauncherDefaultImpl.this.fCurrReportStub = null;
                    } else {
                        ToolLauncherDefaultImpl.this.disableLauncher();
                    }
                    ToolLauncherDefaultImpl.this.splitPane.setDividerLocation(divloc);
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError("Error creating param table", t);
                }
            }
        });
        this.initToLastToolRun();
    }

    @Override
    public void resetParamSet() {
        if (this.getCurrentTool() != null) {
            this.getCurrentParamDisplayComponent().reset();
        }
    }

    @Override
    public Tool getCurrentTool() {
        return this.fCurrTool;
    }

    @Override
    public ParamSet getCurrentParamSet() {
        return this.getCurrentTool().getParamSet();
    }

    @Override
    public boolean isRecordToolRun() {
        return true;
    }

    @Override
    public JComponent getWrappedComponent() {
        return this;
    }

    @Override
    public String getAssociatedTitle() {
        if (this.fTitle != null) {
            return this.fTitle;
        }
        return "Tool Launcher";
    }

    @Override
    public JMenuBar getJMenuBar() {
        return Widget.EMPTY_MENU_BAR;
    }

    @Override
    public Icon getAssociatedIcon() {
        if (this.fIcon == null) {
            return ICON;
        }
        return this.fIcon;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.checkTable();
    }

    private void initToLastToolRun() {
        try {
            String p = Application.getToolManager().getLastToolName();
            if (p == null) {
                return;
            }
            this.fToolSelectorTree.selectTool(p);
        }
        catch (Throwable t) {
            klog.warn(t.getMessage(), t);
        }
    }

    private ParamSetDisplay getCurrentParamDisplayComponent() {
        Tool p = this.getCurrentTool();
        if (p != null) {
            return (ParamSetDisplay)this.fToolParamSetDisplayMap.get(p);
        }
        return null;
    }

    private void checkTable() {
        ParamSet pset = this.fCurrTool.getParamSet();
        boolean ready = pset.isRequiredAllSet();
        this.fToolRunner.setEnabledControls(ready);
    }

    private void disableLauncher() {
        this.fToolRunner.setEnabledControls(false);
        this.splitPane.setRightComponent(GuiHelper.createNaPlaceholder());
        this.splitPane.revalidate();
    }

    private void showToolCategoryInfo(ToolCategory cat) {
        this.fToolRunner.setEnabledControls(false);
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BorderLayout());
        infoPanel.add((Component)new JLabel(cat.getName(), cat.getIcon(), 2), "North");
        JTextArea ta = new JTextArea(this.fToolCatDescMap.get(cat).toString());
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        infoPanel.add((Component)new JScrollPane(ta), "Center");
        this.splitPane.setRightComponent(infoPanel);
        this.splitPane.revalidate();
    }
}

