/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.searchers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneSearchList {
    private JPanel fMainPanel;
    private List<String> fFeatureNames;
    private JList<String> fSearchList;
    private JTextField field = new JTextField(25);
    private DefaultListModel<String> listModel;
    private Logger log = LoggerFactory.getLogger(GeneSearchList.class);

    public GeneSearchList() {
        this.fFeatureNames = new ArrayList<String>();
    }

    public JComponent getComponent() {
        if (this.fMainPanel == null) {
            this.jbInit();
        }
        return this.fMainPanel;
    }

    public void setFeatures(List<String> featureNames) {
        this.log.debug("setFeatures: {}", (Object)featureNames.size());
        this.fFeatureNames = featureNames;
        this.listModel.removeAllElements();
        for (int i = 0; i < this.fFeatureNames.size(); ++i) {
            this.listModel.addElement(this.fFeatureNames.get(i));
        }
        this.fSearchList.revalidate();
        this.fMainPanel.revalidate();
    }

    public String getChosenFeature() {
        return this.field.getText();
    }

    public boolean isChosenFeatureInList() {
        return this.fFeatureNames != null && this.fFeatureNames.contains(this.field.getText());
    }

    public void jbInit() {
        this.listModel = new DefaultListModel();
        for (int i = 0; i < this.fFeatureNames.size(); ++i) {
            this.listModel.addElement(this.fFeatureNames.get(i));
        }
        this.fMainPanel = new JPanel(new BorderLayout(6, 6));
        JPanel quickSelectPanel = new JPanel(new FlowLayout(3));
        quickSelectPanel.add(this.field);
        quickSelectPanel.setBorder(BorderFactory.createTitledBorder("Selected Gene"));
        this.fSearchList = new JList<String>(this.listModel);
        this.fSearchList.setSelectionMode(0);
        this.fSearchList.setVisibleRowCount(50);
        JPanel listPanel = new JPanel(new BorderLayout(2, 2));
        listPanel.setBorder(BorderFactory.createTitledBorder("Feature List"));
        this.fSearchList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                GeneSearchList.this.field.setText(GeneSearchList.this.fSearchList.getSelectedValue());
            }
        });
        listPanel.add(new JScrollPane(this.fSearchList));
        this.fMainPanel.add((Component)quickSelectPanel, "First");
        this.fMainPanel.add((Component)listPanel, "Center");
    }
}

