/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.objmgr;

import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.swing.GPopupChecker;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.explorer.objmgr.ObjectTree;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ObjectTreePopup
extends GPopupChecker {
    private ObjectTree fTree;

    public ObjectTreePopup(ObjectTree tree) {
        this.fTree = tree;
        this.fTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ObjectTreePopup.this.showPopup(e);
                }
            }
        });
    }

    @Override
    protected void maybeShowPopup(MouseEvent e) {
        if (this.isRootExpandClick(e)) {
            this.expandAll();
            return;
        }
        if (e.isPopupTrigger()) {
            this.showPopup(e);
        }
    }

    private void showPopup(MouseEvent e) {
        Object ot = e.getSource();
        if (ot instanceof JTree) {
            PersistentObject pob = this.getSelectedPob();
            if (pob != null) {
                JPopupMenu menu = Application.getWindowManager().createPopupMenu(pob);
                menu.show(e.getComponent(), e.getX(), e.getY());
            }
        } else {
            System.out.println(">>>>  showPopup: " + String.valueOf(ot));
        }
    }

    private boolean isRootExpandClick(MouseEvent e) {
        Object obj;
        if (!e.isShiftDown()) {
            return false;
        }
        TreePath[] paths = this.fTree.getSelectionPaths();
        return paths != null && paths.length == 1 && (obj = paths[0].getLastPathComponent()) == this.fTree.getModel().getRoot();
    }

    private PersistentObject getSelectedPob() {
        PersistentObject[] pobs = this.getSelectedPobs();
        if (pobs == null || pobs.length == 0) {
            return null;
        }
        return pobs[0];
    }

    private PersistentObject[] getSelectedPobs() {
        TreePath[] paths = this.fTree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        ArrayList<Object> pobs = new ArrayList<Object>();
        for (int i = 0; i < paths.length; ++i) {
            Object userobj;
            DefaultMutableTreeNode dmtr;
            Object obj = paths[i].getLastPathComponent();
            if (!(obj instanceof DefaultMutableTreeNode) || (dmtr = (DefaultMutableTreeNode)obj).getAllowsChildren() || !((userobj = dmtr.getUserObject()) instanceof PersistentObject)) continue;
            pobs.add(userobj);
        }
        return pobs.toArray(new PersistentObject[pobs.size()]);
    }

    private void expandAll() {
        try {
            TreePath path = this.fTree.getPathForRow(0);
            if (path == null) {
                return;
            }
            GuiHelper.Tree.expandAll(this.fTree, path);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

