/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.filemgr;

import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.explorer.filemgr.XFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import xapps.gsea.GseaAppConf;

public class XFileChooserImpl
extends JFileChooser
implements XFileChooser {
    public XFileChooserImpl(JList recentFiles) {
        this.initHere(null, recentFiles);
    }

    private void initHere(JList stdDirsList_opt, JList recentFilesList) {
        this.setMouseListener(recentFilesList);
        if (stdDirsList_opt != null) {
            this.setMouseListener(stdDirsList_opt);
        }
        super.setAcceptAllFileFilterUsed(true);
        super.setMultiSelectionEnabled(true);
        super.setFileView(DataFormat.getParsableFileView());
        super.addChoosableFileFilter(GseaAppConf.createGseaFileFilter());
        this.setFileSelectionMode(2);
        Dimension PREF_SIZE = new Dimension(650, 450);
        super.setPreferredSize(PREF_SIZE);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(PREF_SIZE.width - 250, PREF_SIZE.height));
        if (stdDirsList_opt == null) {
            panel.setBorder(BorderFactory.createTitledBorder("Recent folders (double click to list content)"));
            panel.add((Component)new JScrollPane(recentFilesList), "Center");
        } else {
            JScrollPane sp = new JScrollPane(recentFilesList);
            sp.setBorder(BorderFactory.createTitledBorder("Recent folders (double click to list content)"));
            panel.add((Component)sp, "Center");
            sp = new JScrollPane(stdDirsList_opt);
            sp.setPreferredSize(new Dimension(PREF_SIZE.width - 250, 150));
            sp.setBorder(BorderFactory.createTitledBorder("Application folders"));
            panel.add((Component)sp, "South");
        }
        super.setAccessory(panel);
    }

    private void setMouseListener(final JList recentFilesList) {
        recentFilesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int index = recentFilesList.locationToIndex(e.getPoint());
                    ListModel dlm = recentFilesList.getModel();
                    Object item = dlm.getElementAt(index);
                    recentFilesList.ensureIndexIsVisible(index);
                    File file = new File(item.toString());
                    if (file.exists()) {
                        if (!file.isDirectory()) {
                            file = file.getParentFile();
                        }
                        XFileChooserImpl.this.setCurrentLocation(file.getPath());
                    } else {
                        throw new RuntimeException("File not found: " + String.valueOf(file));
                    }
                }
            }
        });
    }

    public void setCurrentLocation(File file) {
        if (file.isDirectory()) {
            super.setCurrentDirectory(file);
        } else {
            super.setSelectedFile(file);
        }
    }

    public void setCurrentLocation(String path) {
        this.setCurrentLocation(new File(path));
    }

    @Override
    public void setApproveButtonText(String txt) {
        super.setApproveButtonText(txt);
    }

    @Override
    public boolean showOpenDialog() {
        int retVal = super.showOpenDialog(Application.getWindowManager().getRootFrame());
        return retVal == 0;
    }
}

