/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.actions.ext.BrowserAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaWebResources;
import xtools.api.param.Validator;

public class DialogDescriptor {
    private static final Logger klog = LoggerFactory.getLogger(DialogDescriptor.class);
    private JPanel fMainPanel;
    private int fChoosenOption = -1;
    private boolean fModal = true;
    private JDialog fDialog;
    private String fTitle;
    private boolean showLicenseButton = false;
    private Action fHelpAction_opt;
    private Action fInfoAction_opt;
    private JButton bCancel;
    private JButton[] fCustomButtons;
    private boolean fAddCancelButton = true;
    private boolean fDisplayWider = false;
    private Validator warningValidator = null;
    private Validator errorValidator = null;
    JPanel botPanel;
    private JButton bOk;
    private JPanel buttonPanel;
    public static final int CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    private static final Dimension DD_SIZE_WIDER = new Dimension(800, 400);
    private static final Dimension DD_SIZE = new Dimension(550, 400);

    public DialogDescriptor(String title, Component inputComp, Action help_action_opt) {
        this.fHelpAction_opt = help_action_opt;
        this.jbInit(title, inputComp);
    }

    public DialogDescriptor(String title, Component inputComp, Action help_action_opt, Action info_action_opt, boolean showLicenseButton) {
        this.showLicenseButton = showLicenseButton;
        this.fHelpAction_opt = help_action_opt;
        this.fInfoAction_opt = info_action_opt;
        this.jbInit(title, inputComp);
    }

    private void jbInit(String title, Component inputComp) {
        this.fTitle = title;
        this.fMainPanel = new JPanel(new BorderLayout(10, 10));
        this.fMainPanel.add(inputComp, "Center");
        this.bCancel = new JButton("Cancel");
    }

    protected void _jbInit_jit_buttons() {
        if (this.botPanel == null) {
            this.botPanel = new JPanel(new BorderLayout(3, 3));
            this.botPanel.add((Component)this.createButtonPanel(), "Center");
            this.botPanel.add(Box.createVerticalStrut(10), "South");
            this.fMainPanel.add((Component)this.botPanel, "Last");
            this.fMainPanel.setPreferredSize(this.fDisplayWider ? DD_SIZE_WIDER : DD_SIZE);
        }
    }

    public int show() {
        this._jbInit_jit_buttons();
        this.fChoosenOption = 2;
        this.fDialog = new JDialog(Application.getWindowManager().getRootFrame(), this.fTitle, this.fModal);
        this.fDialog.setModal(this.fModal);
        this.fMainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fDialog.setContentPane(this.fMainPanel);
        this.fDialog.setResizable(true);
        this.fDialog.pack();
        GuiHelper.centerComponent(this.fDialog);
        this.fDialog.setVisible(true);
        this.fDialog.requestFocus();
        return this.fChoosenOption;
    }

    public void enableDoubleClickableJList(final JList jl) {
        jl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (jl.isSelectionEmpty()) {
                    return;
                }
                if (me.getClickCount() == 2) {
                    me.consume();
                    if (!DialogDescriptor.this.performValidationBeforeOK()) {
                        return;
                    }
                    DialogDescriptor.this.fChoosenOption = 0;
                    if (DialogDescriptor.this.fDialog != null) {
                        DialogDescriptor.this.fDialog.dispose();
                    }
                }
            }
        });
    }

    public void setDisplayWider() {
        this.fDisplayWider = true;
        if (this.fMainPanel != null) {
            this.fMainPanel.setPreferredSize(DD_SIZE_WIDER);
        }
    }

    public void setWarningValidator(Validator warningValidator) {
        this.warningValidator = warningValidator;
    }

    public void setErrorValidator(Validator errorValidator) {
        this.errorValidator = errorValidator;
    }

    public void setButtons(JButton[] boptions) {
        this.fCustomButtons = boptions;
    }

    public void setOnlyShowCloseOption() {
        this.fCustomButtons = new JButton[0];
        this.bCancel.setText("Close");
        this.fAddCancelButton = true;
    }

    private boolean performValidationBeforeOK() {
        if (this.errorValidator != null && !this.errorValidator.isValid()) {
            Errors errors = this.errorValidator.buildValidationFailedErrors();
            klog.error(errors.getName());
            Object errorMsg = "";
            String sep = "";
            for (String err : errors.getErrorsAsStrings()) {
                errorMsg = (String)errorMsg + sep + err;
                sep = SystemUtils.LINE_SEPARATOR;
            }
            Application.getWindowManager().showMessage(errors.getName(), (String)errorMsg);
            return false;
        }
        if (this.warningValidator != null && !this.warningValidator.isValid()) {
            Errors warnings = this.warningValidator.buildValidationFailedErrors();
            Object warningMsg = "";
            String sep = "";
            for (String w : warnings.getErrorsAsStrings()) {
                warningMsg = (String)warningMsg + sep + w;
                sep = SystemUtils.LINE_SEPARATOR;
            }
            boolean confirm = Application.getWindowManager().showConfirm(warnings.getName(), (String)warningMsg);
            if (!confirm) {
                return false;
            }
            klog.warn(warnings.getName());
        }
        return true;
    }

    private JPanel createButtonPanel() {
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BorderLayout());
        if (this.fCustomButtons != null) {
            for (int i = 0; i < this.fCustomButtons.length; ++i) {
                this.buttonPanel.add(this.fCustomButtons[i]);
            }
            if (this.fAddCancelButton) {
                this.bCancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DialogDescriptor.this.fChoosenOption = 2;
                        DialogDescriptor.this.fDialog.setVisible(false);
                        DialogDescriptor.this.fDialog.dispose();
                    }
                });
                this.buttonPanel.add((Component)this.bCancel, "East");
            }
        } else {
            JPanel okCancelHolder = new JPanel();
            BoxLayout okCancelLayout = new BoxLayout(okCancelHolder, 0);
            this.bOk = new JButton("OK");
            okCancelHolder.add(this.bOk);
            okCancelHolder.add(this.bCancel);
            this.buttonPanel.add((Component)okCancelHolder, "East");
            if (this.showLicenseButton) {
                JButton bLicense = new JButton("MSigDB License", GuiHelper.ICON_HELP16);
                bLicense.addActionListener(new BrowserAction("MSigDB License", "MSigDB License Terms", GuiHelper.ICON_HELP16, GseaWebResources.getGseaBaseURL() + "/license_terms_list.jsp"));
                okCancelHolder.add(bLicense);
            }
            JPanel infoHelpHolder = new JPanel();
            BoxLayout infoHelpLayout = new BoxLayout(infoHelpHolder, 0);
            this.buttonPanel.add((Component)infoHelpHolder, "West");
            if (this.fHelpAction_opt != null) {
                JButton bHelp = new JButton("Help");
                bHelp.setAction(this.fHelpAction_opt);
                infoHelpHolder.add(bHelp);
            }
            if (this.fInfoAction_opt != null) {
                JButton bInfo = new JButton("Info");
                bInfo.setAction(this.fInfoAction_opt);
                infoHelpHolder.add(bInfo);
            }
            this.bOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DialogDescriptor.this.performValidationBeforeOK()) {
                        return;
                    }
                    DialogDescriptor.this.fChoosenOption = 0;
                    DialogDescriptor.this.fDialog.setVisible(false);
                    DialogDescriptor.this.fDialog.dispose();
                }
            });
            this.bCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DialogDescriptor.this.fChoosenOption = 2;
                    DialogDescriptor.this.fDialog.setVisible(false);
                    DialogDescriptor.this.fDialog.dispose();
                }
            });
        }
        return this.buttonPanel;
    }
}

