/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.misc_actions;

import edu.mit.broad.genome.TraceUtils;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.FileAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;

public class GeneSetRemoveDuplicatesAction
extends FileAction {
    private File fFile;

    public GeneSetRemoveDuplicatesAction() {
        super("GeneSetRemoveDuplicatesAction", "=> Remove duplicates from the GeneSet", "Remove duplicate members from the gene set. The file will be overwritten with the new data.", null);
    }

    @Override
    public void setFile(File file) {
        this.fFile = file;
    }

    @Override
    public Widget getWidget() {
        Widget widget = null;
        try {
            if (this.fFile != null) {
                if (!this.fFile.getName().endsWith(".grp")) {
                    Application.getWindowManager().showError("Only .grp files allowed - cannot perform this action on file: " + String.valueOf(this.fFile));
                    return null;
                }
                int before = ParseUtils.countLines(this.fFile, true);
                GeneSet gset = (GeneSet)ParserFactory.read(this.fFile);
                ParserFactory.save(gset, this.fFile);
                Application.getWindowManager().showMessage("Successfully removed duplicates from the GeneSet. Before: " + before + " after: " + gset.getNumMembers());
            } else {
                TraceUtils.showTrace();
                Application.getWindowManager().showMessage("No file or object to work on was specified: " + String.valueOf(this.fFile));
            }
        }
        catch (Throwable t) {
            Application.getWindowManager().showError("Error removing duplicates from GeneSet", t);
        }
        return widget;
    }
}

