/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.MGeneSet;
import edu.mit.broad.vdb.map.MappingEtiology;

public class MGeneSetMatrix {
    private MGeneSet[] mappedGeneSets;

    public MGeneSetMatrix(GeneSetMatrix sourceGeneSetMatrix, boolean maintainEtiology, Chip targetChip, Chip2ChipMapper mapper) throws Exception {
        if (sourceGeneSetMatrix == null) {
            throw new IllegalArgumentException("Param sourceGeneSetMatrix cannot be null");
        }
        if (targetChip == null) {
            throw new IllegalArgumentException("Param targetChip cannot be null");
        }
        this.mappedGeneSets = new MGeneSet[sourceGeneSetMatrix.getNumGeneSets()];
        for (int i = 0; i < sourceGeneSetMatrix.getNumGeneSets(); ++i) {
            this.mappedGeneSets[i] = new MGeneSet(sourceGeneSetMatrix.getGeneSet(i), maintainEtiology, targetChip, mapper);
        }
    }

    public MGeneSet getMappedGeneSet(int m) {
        return this.mappedGeneSets[m];
    }

    public int getNumMappedSets() {
        return this.mappedGeneSets.length;
    }

    public MappingEtiology[] getEtiologies() {
        MappingEtiology[] mets = new MappingEtiology[this.getNumMappedSets()];
        for (int i = 0; i < mets.length; ++i) {
            mets[i] = this.getMappedGeneSet(i).getEtiology();
        }
        return mets;
    }
}

