/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import au.com.pegasustech.demos.layout.PointLayout;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.models.GeneSetMatrixModel2;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.viewers.AbstractViewer;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class GeneSetMatrixViewer2
extends AbstractViewer {
    public static final String NAME = "GeneSetMatrixViewer2";
    public static final Icon ICON = JarResources.getIcon("Gmx.png");
    private final GeneSetMatrix fGmx;

    public GeneSetMatrixViewer2(GeneSetMatrix gmx) {
        super(NAME, ICON, gmx);
        this.fGmx = gmx;
        this.init();
    }

    private void init() {
        GeneSetMatrixModel2 gmodel = new GeneSetMatrixModel2(this.fGmx);
        JTable table = GeneSetMatrixViewer2.createTable(gmodel, true, true);
        table.setAutoResizeMode(0);
        this.setLayout((LayoutManager)new PointLayout());
        JTabbedPane tp = new JTabbedPane(3);
        JScrollPane sp = GeneSetMatrixViewer2.createAlwaysScrollPane(table);
        tp.addTab("Data", sp);
        tp.addTab("Info", this.getGeneSetMatrixInfo(this.fGmx));
        this.add(tp);
    }

    private JComponent getGeneSetMatrixInfo(GeneSetMatrix gmx) {
        StringBuffer buf = new StringBuffer("Name: ").append(gmx.getName()).append('\n');
        buf.append("Number of sets: ").append(gmx.getNumGeneSets()).append('\n');
        buf.append("Total number of unique features: ").append(gmx.getAllMemberNamesOnlyOnceS().size()).append('\n');
        String comm = gmx.getComment();
        if (comm != null && comm.length() > 0) {
            buf.append("\nComments\n");
            buf.append(gmx.getComment());
        }
        buf.append("\nGene Set Names\n");
        for (int i = 0; i < gmx.getNumGeneSets(); ++i) {
            buf.append(gmx.getGeneSet(i).getName()).append('\t').append(gmx.getGeneSet(i).getNumMembers()).append('\n');
        }
        JTextArea ta = new JTextArea(buf.toString());
        return new JScrollPane(ta);
    }
}

