/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class ClosableTabComponent
extends JPanel {
    private final JTabbedPane pane;
    private static final MouseListener ButtonBorderMouseListener = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            Component component = e.getComponent();
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                button.setBorderPainted(false);
            }
        }
    };

    public ClosableTabComponent(JTabbedPane pane, String tabLabel, Icon icon) {
        super(new FlowLayout(0, 0, 0));
        if (pane == null) {
            throw new NullPointerException("TabbedPane is null");
        }
        this.pane = pane;
        this.setOpaque(false);
        JLabel label = new JLabel(tabLabel);
        if (icon != null) {
            label.setIcon(icon);
        }
        this.add(label);
        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.add(new CloseTabButton());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
    }

    private class CloseTabButton
    extends JButton
    implements ActionListener {
        public CloseTabButton() {
            this.setToolTipText("Close");
            this.setPreferredSize(new Dimension(18, 18));
            this.setUI(new BasicButtonUI());
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setBorderPainted(false);
            this.setRolloverEnabled(true);
            this.addMouseListener(ButtonBorderMouseListener);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = ClosableTabComponent.this.pane.indexOfTabComponent(ClosableTabComponent.this);
            if (i != -1) {
                ClosableTabComponent.this.pane.remove(i);
            }
        }

        @Override
        public void updateUI() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g.create();
            if (this.getModel().isPressed()) {
                g2.translate(1, 1);
            }
            if (!this.getModel().isRollover()) {
                g2.setColor(Color.BLACK);
            } else {
                g2.setColor(Color.MAGENTA);
            }
            g2.setStroke(new BasicStroke(2.0f));
            g2.drawLine(6, 6, this.getWidth() - 5, this.getHeight() - 5);
            g2.drawLine(this.getWidth() - 5, 6, 6, this.getHeight() - 5);
            g2.dispose();
        }
    }
}

