/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.parsers;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.io.FtpResultInputStream;
import edu.mit.broad.genome.io.FtpSingleUrlTransferCommand;
import edu.mit.broad.genome.objects.Dataframe;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.IDataframe;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ChipParser;
import edu.mit.broad.genome.parsers.ClsParser;
import edu.mit.broad.genome.parsers.DataframeParser;
import edu.mit.broad.genome.parsers.EdbFolderParser;
import edu.mit.broad.genome.parsers.GctParser;
import edu.mit.broad.genome.parsers.GeneSetParser;
import edu.mit.broad.genome.parsers.GmtParser;
import edu.mit.broad.genome.parsers.GmxParser;
import edu.mit.broad.genome.parsers.ObjectCache;
import edu.mit.broad.genome.parsers.PclParser;
import edu.mit.broad.genome.parsers.RankedListParser;
import edu.mit.broad.genome.parsers.ReportParser;
import edu.mit.broad.genome.parsers.ResParser;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.parsers.TxtDatasetParser;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.core.api.Application;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaWebResources;

public class ParserFactory
implements Constants {
    private static final File fileCacheDir = new File(Application.getVdbManager().getRuntimeHomeDir(), "file_cache");
    private static final File chipCacheDir = new File(fileCacheDir, "chip");
    private static final Logger klog;
    private static final ObjectCache kDefaultObjectCache;

    private ParserFactory() {
    }

    static ObjectCache _getCache() {
        return kDefaultObjectCache;
    }

    public static ObjectCache getCache() {
        return ParserFactory._getCache();
    }

    public static void extractGeneSets(GeneSetMatrix gm) {
        ParserFactory._getCache().makeVisible(gm.getGeneSets(), GeneSet.class);
    }

    public static GeneSet combineIntoOne(GeneSetMatrix gm) {
        Set names = gm.getAllMemberNamesOnlyOnceS();
        GeneSet gset = new GeneSet("combo_" + names.size() + "_" + gm.getName(), names);
        ParserFactory._getCache().makeVisible(gset, GeneSet.class);
        return gset;
    }

    public static Dataset readDataset(File file, boolean useCache, boolean add2cache) throws Exception {
        return ParserFactory.readDataset(file.getPath(), ParserFactory.createInputStream(file), useCache, add2cache);
    }

    private static Dataset readDataset(String path, InputStream is, boolean useCache) throws Exception {
        return ParserFactory.readDataset(path, is, useCache, true);
    }

    private static Dataset readDataset(String path, InputStream is, boolean useCache, boolean add2cache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, Dataset.class)) {
            is.close();
            return (Dataset)ParserFactory._getCache().get(path, Dataset.class);
        }
        String ext = NamingConventions.getExtension(path);
        if (ext.equals("gct")) {
            return ParserFactory.readDatasetGct(path, is, useCache, add2cache);
        }
        if (ext.equals("pcl")) {
            return ParserFactory.readDatasetPcl(path, is, useCache, add2cache);
        }
        ResParser parser = new ResParser();
        parser.setSilentMode(false);
        List list = parser.parse(ParserFactory.toName(path), is);
        Dataset ds = (Dataset)list.get(0);
        if (add2cache) {
            ParserFactory._getCache().add(path, (PersistentObject)ds, Dataset.class);
        }
        is.close();
        return ds;
    }

    private static Dataset readDatasetGct(String path, InputStream is, boolean useCache) throws Exception {
        return ParserFactory.readDatasetGct(path, is, useCache, true);
    }

    private static Dataset readDatasetGct(String path, InputStream is, boolean useCache, boolean add2cache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, Dataset.class)) {
            return (Dataset)ParserFactory._getCache().get(path, Dataset.class);
        }
        String ext = NamingConventions.getExtension(path);
        if (ext.equals("res")) {
            return ParserFactory.readDataset(path, is, useCache);
        }
        if (ext.equals("pcl")) {
            return ParserFactory.readDatasetPcl(path, is, useCache);
        }
        GctParser parser = new GctParser();
        parser.setSilentMode(false);
        List list = parser.parse(ParserFactory.toName(path), is);
        Dataset ds = (Dataset)list.get(0);
        if (add2cache) {
            ParserFactory._getCache().add(path, (PersistentObject)ds, Dataset.class);
        }
        is.close();
        return ds;
    }

    private static Dataset readDatasetTXT(String path, InputStream is, boolean useCache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, Dataset.class)) {
            return (Dataset)ParserFactory._getCache().get(path, Dataset.class);
        }
        String ext = NamingConventions.getExtension(path);
        if (ext.equals("res")) {
            return ParserFactory.readDataset(path, is, useCache);
        }
        if (ext.equals("gct")) {
            return ParserFactory.readDatasetGct(path, is, useCache);
        }
        if (ext.equals("pcl")) {
            return ParserFactory.readDatasetPcl(path, is, useCache);
        }
        TxtDatasetParser parser = new TxtDatasetParser();
        parser.setSilentMode(false);
        List list = parser.parse(ParserFactory.toName(path), is);
        Dataset ds = (Dataset)list.get(0);
        ParserFactory._getCache().add(path, (PersistentObject)ds, Dataset.class);
        is.close();
        return ds;
    }

    private static Dataset readDatasetPcl(String path, InputStream is, boolean useCache) throws Exception {
        return ParserFactory.readDatasetPcl(path, is, useCache, true);
    }

    private static Dataset readDatasetPcl(String path, InputStream is, boolean useCache, boolean add2cache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, Dataset.class)) {
            return (Dataset)ParserFactory._getCache().get(path, Dataset.class);
        }
        String ext = NamingConventions.getExtension(path);
        if (ext.equals("res")) {
            return ParserFactory.readDataset(path, is, useCache);
        }
        if (ext.equals("gct")) {
            return ParserFactory.readDatasetGct(path, is, useCache);
        }
        PclParser parser = new PclParser();
        List list = parser.parse(path, is);
        Dataset ds = (Dataset)list.get(0);
        if (add2cache) {
            ParserFactory._getCache().add(path, (PersistentObject)ds, Dataset.class);
        }
        is.close();
        return ds;
    }

    public static Template readTemplate(File file) throws Exception {
        File f = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.readTemplate(file.getPath(), ParserFactory.createInputStream(f), true, true, false);
    }

    public static Template readTemplate(File file, boolean useCache, boolean silentMode) throws Exception {
        File f = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.readTemplate(file.getPath(), ParserFactory.createInputStream(f), useCache, true, silentMode);
    }

    public static Template readTemplate(File file, boolean useCache, boolean add2cache, boolean silentMode) throws Exception {
        File f = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.readTemplate(file.getPath(), ParserFactory.createInputStream(f), useCache, add2cache, silentMode);
    }

    public static Template[] readTemplates(File file) throws Exception {
        File f = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory._readTemplates(file.getPath(), ParserFactory.createInputStream(f), false, false, true);
    }

    private static Template readTemplate(String path_and_aux, InputStream is, boolean useCache, boolean add2cache, boolean silentMode) throws Exception {
        if (path_and_aux == null) {
            throw new IllegalArgumentException("Param path_and_aux cannot be null");
        }
        Template[] templates = ParserFactory._readTemplates(path_and_aux, is, useCache, add2cache, silentMode);
        if (AuxUtils.isAux(path_and_aux)) {
            is.close();
            return ParserFactory.findTemplate(ParserFactory.toName(path_and_aux), templates);
        }
        is.close();
        return templates[0];
    }

    private static Template[] _readTemplates(String path, InputStream is, boolean useCache, boolean add2cache, boolean silentMode) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        HashSet<Object> baseTemplates = new HashSet<Object>();
        String base_path = AuxUtils.getBasePathFromAuxPath(path);
        File basefile = new File(base_path);
        if (useCache && ParserFactory._getCache().isCached(base_path, Template.class)) {
            Object obj = ParserFactory._getCache().get(base_path, Template.class);
            baseTemplates.add(obj);
            is.close();
        } else {
            ClsParser parser = new ClsParser();
            parser.setSilentMode(silentMode);
            if (AuxUtils.isAux(path)) {
                basefile = AuxUtils.getBaseFileFromAuxFile(new File(path));
                list = parser.parse(basefile.getName(), basefile);
                baseTemplates.addAll(list);
            } else {
                list = parser.parse(ParserFactory.toName(path), is);
                baseTemplates.addAll(list);
                basefile = new File(path);
            }
        }
        is.close();
        ArrayList<Template> allTemplates = new ArrayList<Template>();
        Template[] allTss = baseTemplates.toArray(new Template[baseTemplates.size()]);
        for (int j = 0; j < allTss.length; ++j) {
            Template[] tss = TemplateFactory.extractAllPossibleTemplates(allTss[j], true);
            for (int i = 0; i < tss.length; ++i) {
                allTemplates.add(tss[i]);
            }
            if (!silentMode) {
                klog.debug("From: {} (and its supers & auxes) total # of templates made: {}", (Object)path, (Object)allTemplates.size());
            }
            if (!add2cache) continue;
            boolean fire = false;
            for (int t = 0; t < allTemplates.size(); ++t) {
                Template tm = (Template)allTemplates.get(t);
                if (t == allTemplates.size() - 1) {
                    fire = true;
                }
                if (silentMode) {
                    fire = false;
                }
                if (tm.isAux()) {
                    File pseudo = new File(basefile.getParentFile(), tm.getName());
                    ParserFactory._getCache().add(pseudo, (PersistentObject)tm, Template.class, fire);
                    continue;
                }
                ParserFactory._getCache().add(basefile, (PersistentObject)tm, Template.class, fire);
            }
        }
        return allTemplates.toArray(new Template[allTemplates.size()]);
    }

    public static GeneSet readGeneSet(File file, boolean useCache) throws Exception {
        return ParserFactory.readGeneSet(file, useCache, true);
    }

    public static GeneSet readGeneSet(File file, boolean useCache, boolean add2Cache) throws Exception {
        InputStream is = ParserFactory.createInputStream(file);
        return ParserFactory.readGeneSet(file.getPath(), is, useCache, add2Cache);
    }

    private static GeneSet readGeneSet(String path, InputStream is, boolean useCache) throws Exception {
        return ParserFactory.readGeneSet(path, is, useCache, true);
    }

    private static GeneSet readGeneSet(String path, InputStream is, boolean useCache, boolean add2Cache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, GeneSet.class)) {
            is.close();
            return (GeneSet)ParserFactory._getCache().get(path, GeneSet.class);
        }
        if (AuxUtils.isAux(path)) {
            String gsetName = AuxUtils.getAuxNameOnlyNoHash(path);
            File f = AuxUtils.getBaseFileFromAuxFile(new File(path));
            GeneSetMatrix gm = ParserFactory.readGeneSetMatrix(f.getPath(), ParserFactory.createInputStream(f), useCache, true, add2Cache);
            return gm.getGeneSet(gsetName);
        }
        GeneSetParser parser = new GeneSetParser();
        GeneSet gset = (GeneSet)parser.parse(ParserFactory.toName(path), is).get(0);
        ParserFactory._getCache().addInvisibly(path, (PersistentObject)new DefaultGeneSetMatrix(gset.getName(), new GeneSet[]{gset}));
        if (add2Cache) {
            ParserFactory._getCache().add(path, (PersistentObject)gset, GeneSet.class);
        }
        is.close();
        return gset;
    }

    public static Report readReport(File file, boolean useCache) throws Exception {
        if (file.isDirectory()) {
            file = FileUtils.findFile(file, "rpt");
        }
        return ParserFactory.readReport(file.getPath(), ParserFactory.createInputStream(file), useCache);
    }

    private static Report readReport(String path, InputStream is, boolean useCache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, Report.class)) {
            is.close();
            return (Report)ParserFactory._getCache().get(path, Report.class);
        }
        ReportParser parser = new ReportParser();
        Report rpt = (Report)parser.parse(ParserFactory.toName(path), is).get(0);
        if (useCache) {
            ParserFactory._getCache().add(path, (PersistentObject)rpt, Report.class);
        }
        is.close();
        return rpt;
    }

    public static Chip readChip(String sourcePath) throws Exception {
        return ParserFactory.readChip(sourcePath, ParserFactory.createInputStream(sourcePath), true);
    }

    private static Chip readChip(String path, InputStream is, boolean useCache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, Chip.class)) {
            is.close();
            return (Chip)ParserFactory._getCache().get(path, Chip.class);
        }
        ChipParser parser = new ChipParser();
        Chip chip = (Chip)parser.parse(path, is).get(0);
        if (useCache) {
            ParserFactory._getCache().add(path, (PersistentObject)chip, Chip.class);
        }
        is.close();
        return chip;
    }

    public static RankedList readRankedList(File file) throws Exception {
        return ParserFactory.readRankedList(file.getPath(), ParserFactory.createInputStream(file), false);
    }

    private static RankedList readRankedList(String path, InputStream is, boolean useCache) throws Exception {
        if (path == null) {
            throw new IllegalArgumentException("Param path cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(path, RankedList.class)) {
            is.close();
            return (RankedList)ParserFactory._getCache().get(path, RankedList.class);
        }
        RankedListParser parser = new RankedListParser();
        parser.setSilentMode(false);
        RankedList rl = (RankedList)parser.parse(path, is).get(0);
        ParserFactory._getCache().add(path, (PersistentObject)rl, RankedList.class);
        is.close();
        return rl;
    }

    public static EnrichmentDb readEdb(File gseaResultDir, boolean useCache) throws Exception {
        return ParserFactory.readEdb(gseaResultDir, useCache, false);
    }

    public static EnrichmentDb readEdb(File gseaResultDir, boolean useCache, boolean silentMode) throws Exception {
        if (gseaResultDir == null) {
            throw new IllegalArgumentException("Param gseaResultDir cannot be null");
        }
        if (useCache && ParserFactory._getCache().isCached(gseaResultDir, EnrichmentDb.class)) {
            return (EnrichmentDb)ParserFactory._getCache().get(gseaResultDir, EnrichmentDb.class);
        }
        EdbFolderParser folderParser = new EdbFolderParser();
        folderParser.setSilentMode(silentMode);
        EnrichmentDb edb = new EdbFolderParser().parseEdb(gseaResultDir);
        ParserFactory._getCache().add(gseaResultDir, (PersistentObject)edb, EnrichmentDb.class);
        return edb;
    }

    public static GeneSetMatrix readGeneSetMatrix(File file, boolean useCache) throws Exception {
        return ParserFactory.readGeneSetMatrix(file.getPath(), ParserFactory.createInputStream(file), useCache);
    }

    public static GeneSetMatrix readGeneSetMatrix(String path, boolean useCache) throws Exception {
        String ext;
        if (AuxUtils.isAux(path)) {
            path = AuxUtils.getBaseStringFromAux(path);
        }
        if (useCache && !(ext = NamingConventions.getExtension(path)).equals("grp") && ParserFactory._getCache().isCached(path, GeneSetMatrix.class)) {
            return (GeneSetMatrix)ParserFactory._getCache().get(path, GeneSetMatrix.class);
        }
        return ParserFactory.readGeneSetMatrix(path, ParserFactory.createInputStream(path), useCache);
    }

    public static GeneSetMatrix readGeneSetMatrix(String path, InputStream is, boolean useCache) throws Exception {
        return ParserFactory.readGeneSetMatrix(path, is, useCache, true, true);
    }

    private static GeneSetMatrix readGeneSetMatrix(String path, InputStream is, boolean useCache, boolean checkforduplicates, boolean add2Cache) throws Exception {
        String ext;
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (AuxUtils.isAux(path)) {
            path = AuxUtils.getBasePathFromAuxPath(path);
        }
        if ((ext = NamingConventions.getExtension(path)).equals("gmt")) {
            return ParserFactory.readGeneSetMatrixT(path, is, useCache, checkforduplicates, add2Cache);
        }
        if (ext.equals("grp")) {
            GeneSet gset = ParserFactory.readGeneSet(path, is, useCache, add2Cache);
            return new DefaultGeneSetMatrix(ParserFactory.toName(path), new GeneSet[]{gset});
        }
        if (useCache && ParserFactory._getCache().isCached(path, GeneSetMatrix.class)) {
            is.close();
            return (GeneSetMatrix)ParserFactory._getCache().get(path, GeneSetMatrix.class);
        }
        GmxParser parser = new GmxParser();
        parser.setCheckForDuplicates(checkforduplicates);
        GeneSetMatrix gmx = (GeneSetMatrix)parser.parse(ParserFactory.toName(path), is).get(0);
        if (add2Cache) {
            ParserFactory._getCache().add(path, (PersistentObject)gmx, GeneSetMatrix.class);
        }
        File parentFile = new File(path).getParentFile();
        for (int i = 0; i < gmx.getNumGeneSets(); ++i) {
            File pseudo = new File(parentFile, gmx.getGeneSet(i).getName());
            if (!add2Cache) continue;
            ParserFactory._getCache().addInvisibly(pseudo, (PersistentObject)gmx.getGeneSet(i));
        }
        if (add2Cache) {
            ParserFactory._getCache().sortModel(GeneSet.class);
            ParserFactory._getCache().hackAddAuxSets(gmx);
        }
        is.close();
        return gmx;
    }

    private static GeneSetMatrix readGeneSetMatrixT(String path, InputStream is, boolean useCache, boolean checkForDuplicates, boolean add2Cache) throws Exception {
        String ext;
        if (path == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        if (is == null) {
            throw new IllegalArgumentException("Param is cannot be null");
        }
        if (AuxUtils.isAux(path)) {
            path = AuxUtils.getBasePathFromAuxPath(path);
        }
        if ((ext = NamingConventions.getExtension(path)).equals("gmx")) {
            return ParserFactory.readGeneSetMatrix(path, is, useCache, checkForDuplicates, add2Cache);
        }
        String path_name = ParserFactory.toName(path);
        if (ext.equals("grp")) {
            GeneSet gset = ParserFactory.readGeneSet(path, is, useCache);
            return new DefaultGeneSetMatrix(path_name, new GeneSet[]{gset});
        }
        if (useCache && ParserFactory._getCache().isCached(path, GeneSetMatrix.class)) {
            is.close();
            return (GeneSetMatrix)ParserFactory._getCache().get(path, GeneSetMatrix.class);
        }
        GmtParser parser = new GmtParser();
        GeneSetMatrix gmx = (GeneSetMatrix)parser.parse(path, is).get(0);
        ParserFactory._getCache().add(path, (PersistentObject)gmx, GeneSetMatrix.class);
        File parentFile = new File(path).getParentFile();
        for (int i = 0; i < gmx.getNumGeneSets(); ++i) {
            File pseudo = new File(parentFile, gmx.getGeneSet(i).getName());
            ParserFactory._getCache().addInvisibly(pseudo, (PersistentObject)gmx.getGeneSet(i));
        }
        ParserFactory._getCache().hackAddAuxSets(gmx);
        is.close();
        return gmx;
    }

    public static PersistentObject read(String path, InputStream is) throws Exception {
        return ParserFactory.read(path, is, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PersistentObject read(String path, InputStream is, boolean useCache) throws Exception {
        try {
            if (path == null) {
                throw new IllegalArgumentException("Param file cannot be null");
            }
            if (is == null) {
                throw new IllegalArgumentException("Param is cannot be null");
            }
            StringTokenizer tok = new StringTokenizer(path, "@");
            String tmp = tok.nextToken();
            String ext = NamingConventions.getExtensionLiberal(tmp).toLowerCase();
            if (ext.equalsIgnoreCase("res")) {
                Dataset dataset = ParserFactory.readDataset(path, is, useCache);
                return dataset;
            }
            if (ext.equalsIgnoreCase("gct")) {
                Dataset dataset = ParserFactory.readDatasetGct(path, is, useCache);
                return dataset;
            }
            if (ext.equalsIgnoreCase("txt")) {
                Dataset dataset = ParserFactory.readDatasetTXT(path, is, useCache);
                return dataset;
            }
            if (ext.equalsIgnoreCase("pcl")) {
                Dataset dataset = ParserFactory.readDatasetPcl(path, is, useCache);
                return dataset;
            }
            if (ext.startsWith("cls")) {
                Template template = ParserFactory.readTemplate(path, is, useCache, useCache, false);
                return template;
            }
            if (ext.equalsIgnoreCase("grp")) {
                GeneSet geneSet = ParserFactory.readGeneSet(path, is, useCache);
                return geneSet;
            }
            if (ext.equalsIgnoreCase("rnk")) {
                RankedList rankedList = ParserFactory.readRankedList(path, is, useCache);
                return rankedList;
            }
            if (ext.startsWith("gmx")) {
                GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrix(path, is, useCache);
                return geneSetMatrix;
            }
            if (ext.startsWith("gmt")) {
                GeneSetMatrix geneSetMatrix = ParserFactory.readGeneSetMatrixT(path, is, useCache, true, true);
                return geneSetMatrix;
            }
            if (ext.equalsIgnoreCase("edb")) {
                EnrichmentDb enrichmentDb = ParserFactory.readEdb(new File(path), useCache);
                return enrichmentDb;
            }
            if (ext.equalsIgnoreCase("rpt")) {
                Report report = ParserFactory.readReport(path, is, useCache);
                return report;
            }
            if (ext.equalsIgnoreCase("chip") || ext.equalsIgnoreCase("csv")) {
                Chip chip = ParserFactory.readChip(path, is, useCache);
                return chip;
            }
            try {
                throw new IllegalArgumentException("Unknown file format: " + path + " no known Parser for ext: " + ext);
            }
            catch (InterruptedIOException e) {
                klog.info("progress exception - possibly cancelled ... ignoring");
                PersistentObject persistentObject = null;
                return persistentObject;
            }
        }
        finally {
            is.close();
        }
    }

    public static PersistentObject read(File file) throws Exception {
        return ParserFactory.read(file, true);
    }

    public static PersistentObject read(File file, boolean useCache) throws Exception {
        File baseFile = AuxUtils.getBaseFileFromAuxFile(file);
        return ParserFactory.read(file.getPath(), ParserFactory.createInputStream(baseFile), useCache);
    }

    public static void save(PersistentObject pob, File file) throws Exception {
        if (pob == null) {
            throw new IllegalArgumentException("Parameter pob cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter file cannot be null");
        }
        if (pob instanceof Dataset) {
            file = ParserFactory.ensureCorrectExt(file, "res");
            ParserFactory.save((Dataset)pob, file);
        } else if (pob instanceof Template) {
            file = ParserFactory.ensureCorrectExt(file, "cls");
            ParserFactory.save((Template)pob, file);
        } else if (pob instanceof GeneSet) {
            file = ParserFactory.ensureCorrectExt(file, "grp");
            ParserFactory.save((GeneSet)pob, file);
        } else if (pob instanceof RankedList) {
            file = ParserFactory.ensureCorrectExt(file, "rnk");
            ParserFactory.save((RankedList)pob, file);
        } else if (pob instanceof GeneSetMatrix) {
            file = ParserFactory.ensureCorrectExt(file, "gmx");
            ParserFactory.save((GeneSetMatrix)pob, file);
        } else if (pob instanceof Report) {
            file = ParserFactory.ensureCorrectExt(file, "rpt");
            ParserFactory.save((Report)pob, file, true);
        } else if (pob instanceof EnrichmentDb) {
            file = ParserFactory.ensureCorrectExt(file, "edb");
            ParserFactory.save((EnrichmentDb)pob, file);
        } else {
            throw new IllegalArgumentException("No save method available for: " + pob.getName() + " class: " + String.valueOf(pob.getClass()));
        }
    }

    private static File ensureCorrectExt(File file, String exp_ext) {
        String ext = NamingConventions.getExtension(file);
        if (ext.equals(exp_ext)) {
            return file;
        }
        return new File(file.getAbsolutePath() + "." + exp_ext);
    }

    private static File save(Dataset ds, File toFile) throws Exception {
        GctParser parser = new GctParser();
        parser.export((PersistentObject)ds, toFile);
        ParserFactory._getCache().add(toFile, (PersistentObject)ds, Dataset.class);
        return toFile;
    }

    public static File saveGct(Dataset ds, File toFile) throws Exception {
        return ParserFactory.save(ds, toFile);
    }

    public static void saveInvisibly2Cache(IDataframe idf, File toFile) throws Exception {
        if (idf instanceof Dataframe) {
            ParserFactory.saveInvisibly2Cache((Dataframe)idf, toFile);
        } else if (idf instanceof StringDataframe) {
            ParserFactory.saveInvisibly2Cache((StringDataframe)idf, toFile);
        } else {
            throw new NotImplementedException();
        }
    }

    private static void saveInvisibly2Cache(Dataframe df, File toFile) throws Exception {
        DataframeParser parser = new DataframeParser();
        parser.export((PersistentObject)df, toFile);
        ParserFactory._getCache().addInvisibly(toFile, (PersistentObject)df);
    }

    private static void save(EnrichmentDb edb, File toFile) throws Exception {
        EdbFolderParser parser = new EdbFolderParser();
        parser.export((PersistentObject)edb, toFile);
        ParserFactory._getCache().add(toFile, (PersistentObject)edb, EnrichmentDb.class);
    }

    public static void save(RankedList rl, File toFile) throws Exception {
        RankedListParser parser = new RankedListParser();
        parser.export((PersistentObject)rl, toFile);
    }

    public static void save(Template template, File toFile) throws Exception {
        ParserFactory.save(template, toFile, true);
    }

    public static void save(Template template, File toFile, boolean add2cache) throws Exception {
        ClsParser parser = new ClsParser();
        parser.export((PersistentObject)template, toFile);
        if (add2cache) {
            ParserFactory.readTemplate(toFile, true, true, false);
        }
    }

    public static void save(GeneSet gset, File toFile) throws Exception {
        GeneSetParser parser = new GeneSetParser();
        parser.export((PersistentObject)gset, toFile);
        ParserFactory._getCache().add(toFile, (PersistentObject)gset, GeneSet.class);
    }

    public static void saveGmt(GeneSetMatrix gmt, File toFile, boolean add2cache) throws Exception {
        GmtParser parser = new GmtParser();
        parser.export((PersistentObject)gmt, toFile);
        if (add2cache) {
            ParserFactory._getCache().add(toFile, (PersistentObject)gmt, GeneSetMatrix.class);
        }
    }

    public static void save(GeneSetMatrix gmx, File toFile) throws Exception {
        GmxParser parser = new GmxParser();
        parser.export((PersistentObject)gmx, toFile);
        ParserFactory._getCache().add(toFile, (PersistentObject)gmx, GeneSetMatrix.class);
    }

    public static void save(Report rpt, File toFile, boolean add2cache) throws Exception {
        ReportParser parser = new ReportParser();
        parser.export((PersistentObject)rpt, toFile);
        if (add2cache) {
            ParserFactory._getCache().add(toFile, (PersistentObject)rpt, Report.class);
        }
    }

    public static void save(StringDataframe sdf, File toFile, boolean add2cache) throws Exception {
        StringDataframeParser parser = new StringDataframeParser();
        parser.export((PersistentObject)sdf, toFile);
        if (add2cache) {
            ParserFactory._getCache().add(toFile, (PersistentObject)sdf, StringDataframe.class);
        }
    }

    private static void saveInvisibly2Cache(StringDataframe sdf, File toFile) throws Exception {
        StringDataframeParser parser = new StringDataframeParser();
        parser.export((PersistentObject)sdf, toFile);
        ParserFactory._getCache().addInvisibly(toFile, (PersistentObject)sdf);
    }

    private static Template findTemplate(String name, Template[] tss) {
        if (AuxUtils.getAuxNameOnlyNoHash(name).equals(AuxUtils.getBaseStringFromAux(name))) {
            name = AuxUtils.getAuxNameOnlyNoHash(name);
        }
        if (AuxUtils.isAux(name) && name.endsWith(".cls")) {
            name = name.substring(0, name.length() - 4);
        }
        for (int t = 0; t < tss.length; ++t) {
            if (tss[t].getName().equals(name)) {
                return tss[t];
            }
            if (!tss[t].isContinuous()) continue;
            String name_no_aux = AuxUtils.getAuxNameOnlyNoHash(name);
            if (!tss[t].getName().equals(name_no_aux)) continue;
            return tss[t];
        }
        StringBuffer buf = new StringBuffer("<html>\n<body>\n<p>No template for name: " + name + "</p><p>The Available templates are:</p>\n");
        for (int i = 0; i < tss.length; ++i) {
            buf.append(tss[i].getName()).append("<br>\n");
        }
        buf.append("</body></html>");
        throw new IllegalArgumentException(buf.toString());
    }

    private static String toName(String path) {
        return new File(path).getName();
    }

    private static InputStream createInputStream(File file) throws IOException {
        if (NamingConventions.isURL(file.getPath())) {
            return ParserFactory.createInputStream(URI.create(file.getPath()).toURL());
        }
        if (AuxUtils.isAuxFile(file)) {
            file = AuxUtils.getBaseFileFromAuxFile(file);
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        if (file.isDirectory()) {
            throw new IOException("Specified path is a Directory (expecting a File): " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException("Check file permissions - cannot read data from file: " + file.getAbsolutePath());
        }
        return new BufferedInputStream(new FileInputStream(file));
    }

    private static InputStream createInputStream(URL url) throws IOException {
        klog.debug("Parsing URL: {} >> {}", (Object)url.getPath(), (Object)url.toString());
        if (url.getProtocol().equalsIgnoreCase("ftp") && url.getHost().equalsIgnoreCase(GseaWebResources.getGseaFTPServer())) {
            try {
                FtpSingleUrlTransferCommand ftpCommand = new FtpSingleUrlTransferCommand(url);
                FtpResultInputStream ftpInputStream = ftpCommand.retrieveAsInputStream();
                return ftpInputStream;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return new BufferedInputStream(url.openStream());
    }

    private static InputStream createInputStream(Object source) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        if (source instanceof File) {
            return ParserFactory.createInputStream((File)source);
        }
        if (source instanceof URL) {
            return ParserFactory.createInputStream((URL)source);
        }
        Object path = source.toString();
        if (NamingConventions.isURL((String)path)) {
            if (((String)path).startsWith("ftp.")) {
                path = "ftp://" + (String)path;
            } else if (((String)path).startsWith("gseaftp.")) {
                path = "ftp://" + (String)path;
            }
            return ParserFactory.createInputStream(URI.create((String)path).toURL());
        }
        File file = new File((String)path);
        if (file.exists()) {
            return ParserFactory.createInputStream(file);
        }
        throw new IOException("Bad data source -- neither file nor url exists for: " + String.valueOf(source));
    }

    public static void saveGmt(GeneSetMatrix gmt, File toFile) throws Exception {
        GmtParser parser = new GmtParser();
        parser.export((PersistentObject)gmt, toFile);
        ParserFactory._getCache().add(toFile, (PersistentObject)gmt, GeneSetMatrix.class);
    }

    static {
        if (!chipCacheDir.exists()) {
            chipCacheDir.mkdirs();
        }
        klog = LoggerFactory.getLogger(ParserFactory.class);
        kDefaultObjectCache = new ObjectCache();
    }
}

