/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.MetricWeightStruc;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.ParserFactory;
import java.io.File;
import java.util.List;

public class RankedListJITImpl
extends AbstractObject
implements RankedList {
    private File fRlFile;
    private RankedList fRl;

    public RankedListJITImpl(File rlFile) {
        if (rlFile == null || !rlFile.exists()) {
            throw new IllegalArgumentException("rlFile doesnt not exist: " + String.valueOf(rlFile));
        }
        super.initialize(rlFile.getName());
        this.fRlFile = rlFile;
    }

    private RankedList _rl() {
        try {
            if (this.fRl == null) {
                this.fRl = ParserFactory.readRankedList(this.fRlFile);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.fRl;
    }

    @Override
    public RankedList cloneShallowRL(String newName) {
        return this._rl().cloneShallowRL(newName);
    }

    @Override
    public String getQuickInfo() {
        return this._rl().getQuickInfo();
    }

    @Override
    public String getRankName(int rank) {
        return this._rl().getRankName(rank);
    }

    @Override
    public List<String> getRankedNames() {
        return this._rl().getRankedNames();
    }

    @Override
    public String[] getRankedNamesArray() {
        return this._rl().getRankedNamesArray();
    }

    @Override
    public int getRank(String name) {
        return this._rl().getRank(name);
    }

    @Override
    public Vector getScoresV(boolean clonedCopy) {
        return this._rl().getScoresV(clonedCopy);
    }

    @Override
    public float getScore(int rank) {
        return this._rl().getScore(rank);
    }

    @Override
    public float getScore(String name) {
        return this._rl().getScore(name);
    }

    @Override
    public float[] getScores(GeneSet gset) {
        return this._rl().getScores(gset);
    }

    @Override
    public RankedList extractRanked(GeneSet gset) {
        return this._rl().extractRanked(gset);
    }

    @Override
    public int getSize() {
        return this._rl().getSize();
    }

    @Override
    public int getSize(ScoreMode smode) {
        return this._rl().getSize(smode);
    }

    @Override
    public List<String> getNamesOfUpOrDnXRanks(int topOrBotX, boolean top) {
        return this._rl().getNamesOfUpOrDnXRanks(topOrBotX, top);
    }

    @Override
    public MetricWeightStruc getMetricWeightStruc() {
        return this._rl().getMetricWeightStruc();
    }

    @Override
    public RankedList extractRanked(ScoreMode smode) {
        return this._rl().extractRanked(smode);
    }
}

