/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.objects.AbstractPreTemplate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PreTemplateImpl
extends AbstractPreTemplate {
    private Pair[] fPairs;
    private Map fSampleNamePairMap;
    private boolean fContinuous;
    private int fNumClasses;

    public PreTemplateImpl(String sourcefileName, String justPhenoName, Pair[] pairs, boolean continuous) {
        super(sourcefileName + "#" + justPhenoName);
        for (int i = 0; i < pairs.length; ++i) {
            if (pairs[i] instanceof NumPair && !continuous) {
                throw new IllegalArgumentException("NumPair but not continuous");
            }
            if (!(pairs[i] instanceof StringPair) || !continuous) continue;
            throw new IllegalArgumentException("StringPair but continuous");
        }
        this.fPairs = pairs;
        this.fContinuous = continuous;
        this.fSampleNamePairMap = new HashMap();
        HashSet<Object> uniqValues = new HashSet<Object>();
        for (int p = 0; p < pairs.length; ++p) {
            if (pairs[p] == null) {
                throw new IllegalArgumentException("Param pairs cannot be null at index: " + p);
            }
            if (this.fSampleNamePairMap.containsKey(pairs[p].getSampleName())) {
                throw new IllegalArgumentException("Duplicate sample names: " + pairs[p].getSampleName());
            }
            this.fSampleNamePairMap.put(pairs[p].getSampleName(), pairs[p]);
            if (this.fContinuous) continue;
            uniqValues.add(pairs[p].getValue());
        }
        this.fNumClasses = this.fContinuous ? this.fSampleNamePairMap.size() : uniqValues.size();
    }

    @Override
    public int getNumClasses() {
        return this.fNumClasses;
    }

    @Override
    public boolean isContinuous() {
        return this.fContinuous;
    }

    @Override
    public boolean isCategorical() {
        return !this.fContinuous;
    }

    @Override
    public boolean isAux() {
        return this.fContinuous;
    }

    @Override
    public String getQuickInfo() {
        StringBuffer buf = new StringBuffer();
        if (this.isContinuous()) {
            buf.append(this.fPairs.length).append("=>C");
        } else {
            buf.append(this.fPairs.length).append("=>").append(this.getNumClasses());
        }
        return buf.toString();
    }

    public static class NumPair
    implements Pair {
        String sampleName;
        float classValue;

        public NumPair(String sampleName, String classValue) {
            this.sampleName = sampleName;
            this.classValue = Float.parseFloat(classValue);
        }

        @Override
        public String getSampleName() {
            return this.sampleName;
        }

        @Override
        public Object getValue() {
            return Float.valueOf(this.classValue);
        }
    }

    public static class StringPair
    implements Pair {
        String sampleName;
        String className;

        public StringPair(String sampleName, String className) {
            this.sampleName = sampleName;
            this.className = className;
        }

        @Override
        public String getSampleName() {
            return this.sampleName;
        }

        @Override
        public Object getValue() {
            return this.className;
        }
    }

    public static interface Pair {
        public String getSampleName();

        public Object getValue();
    }
}

