/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.objects;

import edu.mit.broad.genome.math.ColorSchemes;
import edu.mit.broad.genome.math.GraphMode;
import edu.mit.broad.genome.math.Orientation;
import edu.mit.broad.genome.math.ScaleMode;
import edu.mit.broad.genome.objects.Dataset;
import java.awt.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ColorDataset
extends Dataset {
    public static final ScaleMode DEFAULT_SCALE_MODE = ScaleMode.REL_MEAN;
    public static final Orientation DEFAULT_ORIENTATION = Orientation.ROW;
    public static final GraphMode DEFAULT_GRAPH_MODE = GraphMode.LINEAR;

    public Color getColor(int var1, int var2);

    public static class Helper {
        private static final Logger klog = LoggerFactory.getLogger(Helper.class);

        public static Color computeRelativeMeanColor(double x, double min, double max, double mean, GraphMode graphMode, ColorSchemes.ColorScheme colorScheme, boolean colorZeroAsWhite) {
            if (colorZeroAsWhite && x == 0.0) {
                return Color.WHITE;
            }
            if (graphMode.isLinear()) {
                double cVal = 0.5;
                Color color = null;
                int ind = -1;
                try {
                    if (x < min) {
                        x = min;
                    }
                    if (x >= max) {
                        x = max;
                    }
                    cVal = (x - min) / (max - min);
                    if (mean != Double.NEGATIVE_INFINITY) {
                        cVal = x <= mean ? 0.5 * (x - min) / (mean - min) : 0.5 + 0.5 * (x - mean) / (max - mean);
                    }
                    if ((ind = (int)(cVal * (double)colorScheme.getNumColors())) == colorScheme.getNumColors()) {
                        ind = colorScheme.getNumColors() - 1;
                    }
                    color = colorScheme.getColor(ind);
                }
                catch (Exception e) {
                    klog.error("ColorMatrix: Cval: {} Xval: {} Index: {} Min: {} Max: {} Mean: {}", new Object[]{cVal, x, ind, min, max, mean});
                    klog.error(e.getMessage(), (Throwable)e);
                }
                return color;
            }
            if (graphMode.IsLog()) {
                return colorScheme.getMinColor();
            }
            throw new IllegalStateException("Unknown GraphMode: " + String.valueOf(graphMode));
        }

        public static Color computeRelativeMedianColor(double x, double min, double max, double median, GraphMode graphMode, ColorSchemes.ColorScheme colorScheme) {
            if (graphMode.isLinear()) {
                double cVal = 0.5;
                Color color = null;
                int ind = -1;
                try {
                    if (x < min) {
                        x = min;
                    }
                    if (x >= max) {
                        x = max;
                    }
                    cVal = (x - min) / (max - min);
                    if (median != Double.NEGATIVE_INFINITY) {
                        cVal = x <= median ? 0.5 * (x - min) / (median - min) : 0.5 + 0.5 * (x - median) / (max - median);
                    }
                    if ((ind = (int)(cVal * (double)colorScheme.getNumColors())) == colorScheme.getNumColors()) {
                        ind = colorScheme.getNumColors() - 1;
                    }
                    color = colorScheme.getColor(ind);
                }
                catch (Exception e) {
                    klog.error("ColorMatrix: Cval: {} Xval: {} Index: {} Min: {} Max: {} Median: {}", new Object[]{cVal, x, ind, min, max, median});
                    klog.error(e.getMessage(), (Throwable)e);
                }
                return color;
            }
            if (graphMode.IsLog()) {
                return colorScheme.getMinColor();
            }
            throw new IllegalStateException("Unknown graphmode: " + String.valueOf(graphMode));
        }

        public static Color computeAbsoluteColor(float x, GraphMode graphMode, ColorSchemes.ColorScheme colorScheme) {
            if (graphMode.isLinear()) {
                float min = 0.0f;
                float max = 8000.0f;
                float mean = Float.NEGATIVE_INFINITY;
                float cVal = 0.5f;
                Color color = null;
                int ind = -1;
                try {
                    if (x < min) {
                        x = min;
                    }
                    if (x >= max) {
                        x = max;
                    }
                    cVal = (x - min) / (max - min);
                    if (mean != Float.NEGATIVE_INFINITY) {
                        cVal = x <= mean ? 0.5f * (x - min) / (mean - min) : 0.5f + 0.5f * (x - mean) / (max - mean);
                    }
                    if ((ind = (int)(cVal * (float)colorScheme.getNumColors())) == colorScheme.getNumColors()) {
                        ind = colorScheme.getNumColors() - 1;
                    }
                    color = colorScheme.getColor(ind);
                }
                catch (Exception e) {
                    klog.error("ColorMatrix: Cval: {} Xval: {} Index: {} Min: {} Max: {} Mean: {}", new Object[]{Float.valueOf(cVal), Float.valueOf(x), ind, Float.valueOf(min), Float.valueOf(max), Float.valueOf(mean)});
                    klog.error(e.getMessage(), (Throwable)e);
                }
                return color;
            }
            if (graphMode.IsLog()) {
                return colorScheme.getMinColor();
            }
            throw new IllegalStateException("Unknown GraphMode:" + String.valueOf(graphMode));
        }
    }
}

