/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg.gsea;

import edu.mit.broad.genome.alg.gsea.Norm;
import edu.mit.broad.genome.math.Matrix;
import edu.mit.broad.genome.math.ScoreMode;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.DefaultDataset;
import edu.mit.broad.genome.objects.LabelledVector;
import java.util.ArrayList;

public class Norms {
    public static final String NONE = None.NAME;
    public static final String MEANDIV_POS_NEG_SEPERATE = MeanDivPosNegSeperate.NAME;

    public static String[] createNormModeNames() {
        return new String[]{NONE, MEANDIV_POS_NEG_SEPERATE};
    }

    public static Norm createNorm(String normModeName, float realScore, Vector rndScores) {
        if (normModeName == null) {
            throw new IllegalArgumentException("Param normModeName cannot be null");
        }
        if (normModeName.equals(NONE)) {
            return new None(realScore, rndScores);
        }
        if (normModeName.equals(MEANDIV_POS_NEG_SEPERATE)) {
            return new MeanDivPosNegSeperate(realScore, rndScores);
        }
        throw new IllegalArgumentException("Unknown norm mode: " + normModeName);
    }

    public static Struc normalize(String normName, LabelledVector realScores, Dataset rndScores_full) {
        Vector normRealScores = new Vector(realScores.getSize());
        String[] labels = new String[realScores.getSize()];
        ArrayList<String> labels_list = new ArrayList<String>();
        Matrix normRndScoresMatrix = new Matrix(realScores.getSize(), rndScores_full.getNumCol());
        for (int r = 0; r < realScores.getSize(); ++r) {
            String rowName = realScores.getLabel(r);
            float real = realScores.getScore(rowName);
            Norm norm = Norms.createNorm(normName, real, rndScores_full.getRow(rowName));
            normRndScoresMatrix.setRow(r, norm.getRandomNorm());
            normRealScores.setElement(r, norm.getRealNorm());
            labels[r] = rowName;
            labels_list.add(rowName);
        }
        Struc struc = new Struc();
        struc.normReal = new LabelledVector(realScores.getName() + "_norm", labels, normRealScores);
        struc.normRnd = new DefaultDataset("norm", normRndScoresMatrix, labels_list, rndScores_full.getColumnNames(), rndScores_full.getAnnot());
        return struc;
    }

    public static class None
    extends AbstractNormOne {
        private static String NAME = "None";

        public None(float real, Vector rnd) {
            super(NAME);
            this.real_orig = real;
            this.rndNorm = this.rnd_orig = rnd;
            this.realNorm = this.real_orig;
        }
    }

    public static class MeanDivPosNegSeperate
    extends AbstractNormOne {
        private static String NAME = "meandiv";
        int numRndPos;
        int numRndNeg;
        float meanPos_orig;
        float varPos_orig;
        float meanNeg_orig;
        float varNeg_orig;

        public MeanDivPosNegSeperate(float real, Vector rnd) {
            super(NAME);
            this.real_orig = real;
            this.rnd_orig = rnd;
            Vector onlyPos = this.rnd_orig.extract(ScoreMode.POS_ONLY);
            Vector onlyNeg = this.rnd_orig.extract(ScoreMode.NEG_ONLY);
            this.meanPos_orig = (float)onlyPos.mean();
            this.varPos_orig = (float)Math.sqrt(onlyPos.var(false, false));
            this.meanNeg_orig = (float)onlyNeg.mean();
            this.varNeg_orig = (float)Math.sqrt(onlyNeg.var(false, false));
            int rnd_origSize = this.rnd_orig.getSize();
            this.rndNorm = new Vector(rnd_origSize);
            for (int i = 0; i < rnd_origSize; ++i) {
                float score;
                float orig = this.rnd_orig.getElement(i);
                if (XMath.isPositive(orig)) {
                    score = orig / this.meanPos_orig;
                    this.rndNorm.setElement(i, score);
                    ++this.numRndPos;
                    continue;
                }
                score = orig / Math.abs(this.meanNeg_orig);
                this.rndNorm.setElement(i, score);
                ++this.numRndNeg;
            }
            this.realNorm = XMath.isPositive(this.real_orig) ? this.real_orig / this.meanPos_orig : this.real_orig / Math.abs(this.meanNeg_orig);
        }
    }

    public static class Struc {
        public LabelledVector normReal;
        public Dataset normRnd;
    }

    private static abstract class AbstractNormOne
    implements Norm {
        float real_orig;
        float realNorm;
        Vector rnd_orig;
        Vector rndNorm;
        String normModeName;

        AbstractNormOne(String normModeName) {
            this.normModeName = normModeName;
        }

        @Override
        public Vector getRandomNorm() {
            return this.rndNorm;
        }

        @Override
        public float getRealNorm() {
            return this.realNorm;
        }
    }
}

