/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.alg;

import edu.mit.broad.genome.alg.AlgMap;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.VectorSplitter;
import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xtools.api.param.BadParamException;

public class DatasetStatsCore {
    private Logger log = LoggerFactory.getLogger(DatasetStatsCore.class);

    public boolean calc2ClassCategoricalMetricMarkerScores(Dataset ds, Template template, Metric metric, Map<String, Boolean> params, Map<String, TwoClassMarkerStats> markerScores) {
        boolean reqThreeSamplesPerClass;
        if (!metric.isCategorical()) {
            throw new IllegalArgumentException("Not a 2 class categorical metric: " + String.valueOf(metric));
        }
        if (template.getNumClasses() != 2) {
            throw new RuntimeException("Template is not biphasic. Name: " + template.getName() + "\n<br>This metric can only be used with 2 class comparisons");
        }
        boolean bl = reqThreeSamplesPerClass = metric.getName().equalsIgnoreCase("Signal2Noise") || metric.getName().equalsIgnoreCase("tTest");
        if (reqThreeSamplesPerClass) {
            if (ds.getNumCol() < 6) {
                throw new BadParamException("Too few samples in the dataset to use this metric", 1006);
            }
            if (template.getClass(0).getSize() < 3) {
                throw new BadParamException("Too few samples in class A of the dataset to use this metric", 1006);
            }
            if (template.getClass(1).getSize() < 3) {
                throw new BadParamException("Too few samples in class B of the dataset to use this metric", 1006);
            }
        }
        boolean usebiased = AlgMap.isBiased(params);
        boolean fixlow = AlgMap.isFixLowVar(params);
        boolean useMedian = AlgMap.isMedian(params);
        int minSampleCount = metric.getMinNumSamplesNeededPerClassForCalculation();
        VectorSplitter splitter = new VectorSplitter(minSampleCount);
        boolean foundRowsWithMissingData = false;
        for (int r = 0; r < ds.getNumRow(); ++r) {
            String rowName = ds.getRowName(r);
            Vector profile = ds.getRow(r);
            Vector[] vs = splitter.splitBiphasic(profile, template);
            vs[0] = vs[0].toVectorNaNless();
            vs[1] = vs[1].toVectorNaNless();
            TwoClassMarkerStats stats = new TwoClassMarkerStats();
            if (vs == null || vs[0] == null || vs[1] == null || vs[0].getSize() == 0 || vs[1].getSize() == 0) {
                stats.score = Double.NaN;
                stats.me0 = Double.NaN;
                stats.me1 = Double.NaN;
                stats.me_all = Double.NaN;
                stats.stdev0 = Double.NaN;
                stats.stdev1 = Double.NaN;
                stats.stdev_all = Double.NaN;
                this.log.warn("Omitting row {} of this dataset with name '{}' as all the data is missing for one or both of the classes.", (Object)(r + 1), (Object)rowName);
                stats.omit = true;
                foundRowsWithMissingData = true;
            } else {
                if (vs[0].getSize() < minSampleCount || vs[1].getSize() < minSampleCount) {
                    this.log.warn("In row {} of this dataset with name '{}', one or both of the classes has too few samples to use the chosen metric", (Object)(r + 1), (Object)rowName);
                }
                stats.score = (float)metric.getScore(profile, template, params);
                Vector full = new Vector(vs);
                if (useMedian) {
                    stats.me0 = vs[0].median();
                    stats.me1 = vs[1].median();
                    stats.me_all = full.median();
                } else {
                    stats.me0 = vs[0].meanNaNsafe();
                    stats.me1 = vs[1].meanNaNsafe();
                    stats.me_all = full.meanNaNsafe();
                }
                stats.stdev0 = (float)vs[0].stddev(usebiased, fixlow);
                stats.stdev1 = (float)vs[1].stddev(usebiased, fixlow);
                stats.stdev_all = (float)full.stddev(usebiased, fixlow);
            }
            if (markerScores.containsKey(rowName)) {
                throw new RuntimeException("Duplicate row names in dataset: " + ds.getName() + " rowname: " + rowName + " row: " + (r + 1));
            }
            markerScores.put(rowName, stats);
        }
        return foundRowsWithMissingData;
    }

    public static class TwoClassMarkerStats {
        private double score;
        private double me0;
        private double stdev0;
        private double me1;
        private double stdev1;
        private double me_all;
        private double stdev_all;
        public boolean omit = false;

        public double getScore() {
            return this.score;
        }

        public double getMe0() {
            return this.me0;
        }

        public double getMe_all() {
            return this.me_all;
        }

        public double getStdev0() {
            return this.stdev0;
        }

        public double getMe1() {
            return this.me1;
        }

        public double getStdev1() {
            return this.stdev1;
        }

        public double getStdev_all() {
            return this.stdev_all;
        }
    }
}

