/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome;

import edu.mit.broad.genome.StandardException;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xapps.gsea.GseaWebResources;

public class JarResources {
    public static Icon ICON_NOT_FOUND;
    public static Icon ICON_UNKNOWN_DATA_FORMAT;
    private static final String PKG_GENOME = "/edu/mit/broad/genome/";
    private static final String PKG_RESOURCE = "/edu/mit/broad/genome/resources/";
    private static Logger klog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getBuildInfo() {
        Properties properties;
        URL url = JarResources.toURL("build.properties");
        Properties buildProps = new Properties();
        InputStream urlStream = url.openStream();
        try {
            buildProps.load(urlStream);
            properties = buildProps;
        }
        catch (Throwable throwable) {
            try {
                urlStream.close();
                throw throwable;
            }
            catch (Throwable t) {
                klog.error(t.getMessage(), t);
                return buildProps;
            }
        }
        urlStream.close();
        return properties;
    }

    private JarResources() {
    }

    public static URL toURL(String filename) {
        return JarResources.class.getResource(PKG_RESOURCE + filename);
    }

    public static JButton createHelpButton(String keyName) {
        Action a = JarResources.createHelpAction(keyName);
        if (a != null) {
            return new JButton(a);
        }
        return new JButton("Help broken: " + keyName);
    }

    public static Action createDataFormatAction(String dfAnchor) {
        final String url = GseaWebResources.getGseaDataFormatsHelpURL() + dfAnchor;
        return new AbstractAction("Help", JarResources.getIcon("Help16_v2.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError(url + ": unable to launch web browser", t);
                }
            }
        };
    }

    public static Action createHelpAction(String ugAnchor) {
        final String url = GseaWebResources.getGseaHelpURL() + "GSEA/GSEA_User_Guide/" + ugAnchor;
        return new AbstractAction("Help", JarResources.getIcon("Help16_v2.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError("Unable to launch web browser for " + url, t);
                }
            }
        };
    }

    public static Action createHelpAction(StandardException se) {
        final String url = GseaWebResources.getGseaHelpURL() + "GSEA/GSEA_User_Guide/#error-" + se.getErrorCode();
        return new AbstractAction("Help for error " + se.getErrorCode(), JarResources.getIcon("Help16_v2.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (Throwable t) {
                    Application.getWindowManager().showError("Unable to launch web browser for " + url, t);
                }
            }
        };
    }

    public static Icon getIcon(String name) {
        URL url = null;
        try {
            url = JarResources.toURL(name);
            if (url != null) {
                return new ImageIcon(url);
            }
        }
        catch (Throwable t) {
            klog.error(t.getMessage(), t);
        }
        klog.warn("could not find resource: {} url: {} ... using default icon instead.", (Object)name, (Object)url);
        return ICON_NOT_FOUND;
    }

    public static ImageIcon getImageIcon(String name) {
        return (ImageIcon)JarResources.getIcon(name);
    }

    public static Image getImage(String name) {
        return ((ImageIcon)JarResources.getIcon(name)).getImage();
    }

    static {
        klog = LoggerFactory.getLogger(JarResources.class);
        try {
            if (!GraphicsEnvironment.isHeadless()) {
                klog.debug("Loading basic icons ...");
                URL nf_url = JarResources.class.getResource("/edu/mit/broad/genome/resources/IconNotFound.gif");
                if (nf_url == null) {
                    System.err.println("FATAL resources error ICON_NOT_FOUND not found!");
                    System.err.println("Expected location: /edu/mit/broad/genome/resources/IconNotFound.gif");
                    ICON_NOT_FOUND = null;
                    ICON_UNKNOWN_DATA_FORMAT = null;
                } else {
                    Image image = Toolkit.getDefaultToolkit().getImage(nf_url);
                    if (image == null) {
                        System.err.println("FATAL resources error ICON_NOT_FOUND not found!");
                        System.err.println("Expected location: resources/IconNotFound.gif");
                    }
                    ICON_NOT_FOUND = new NotFoundIcon(image);
                    URL qu = JarResources.class.getResource("/edu/mit/broad/genome/resources/UnknownDataFormat16.gif");
                    if (qu != null) {
                        image = Toolkit.getDefaultToolkit().getImage(qu);
                        ICON_UNKNOWN_DATA_FORMAT = new ImageIcon(image);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Fatal error initializing JarResources " + t.getMessage());
        }
    }

    public static class NotFoundIcon
    extends ImageIcon {
        NotFoundIcon(Image image) {
            super(image);
        }
    }
}

